/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile.base;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import io.github.phantamanta44.libnine.tile.L9TileEntityTicking;
import io.github.phantamanta44.threng.ThrEng;
import io.github.phantamanta44.threng.tile.base.IReadyable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileAENetworked
extends L9TileEntityTicking
implements IActionHost,
IGridProxyable,
IReadyable {
    protected final IActionSource actionSource = new MachineSource((IActionHost)this);
    private final AENetworkProxy aeProxy = new AENetworkProxy((IGridProxyable)this, "aeproxy", this.getNetworkRepresentation(), true);

    public TileAENetworked() {
        this.setInitialized();
    }

    @Override
    public void onReady() {
        this.getProxy().onReady();
        this.initProxy(this.getProxy());
        Platform.notifyBlocksOfNeighbors((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Nullable
    protected abstract ItemStack getNetworkRepresentation();

    protected void initProxy(AENetworkProxy proxy) {
    }

    public AENetworkProxy getProxy() {
        return this.aeProxy;
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation aePartLocation) {
        return this.getProxy().getNode();
    }

    public Optional<IGrid> aeGrid() {
        return Optional.ofNullable(this.getProxy().getNode()).map(IGridNode::getGrid);
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.getProxy().onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getProxy().invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.getProxy().validate();
        ThrEng.PROXY.getTileReadyHandler().enqueue(this);
    }

    public void deserNBT(NBTTagCompound nbt) {
        super.deserNBT(nbt);
        this.getProxy().readFromNBT(nbt);
    }

    public void serNBT(NBTTagCompound tag) {
        super.serNBT(tag);
        this.getProxy().writeToNBT(tag);
    }
}

