/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import io.github.phantamanta44.threng.block.BlockMachine;
import io.github.phantamanta44.threng.client.gui.GuiLevelMaintainer;
import io.github.phantamanta44.threng.tile.base.TileNetworkDevice;
import io.github.phantamanta44.threng.util.ThrEngCraftingTracker;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandlerModifiable;

@RegisterTile(value="threng")
public class TileLevelMaintainer
extends TileNetworkDevice
implements IStackWatcherHost,
ICraftingRequester {
    public static final int REQ_COUNT = 5;
    @AutoSerialize
    private final InventoryRequest requests = new InventoryRequest(this);
    @AutoSerialize
    private final ThrEngCraftingTracker crafter = new ThrEngCraftingTracker(this, 5);
    @Nullable
    private IStackWatcher watcher;
    private long[] knownCounts = new long[5];
    private int sleepTicks = 0;

    public TileLevelMaintainer() {
        this.markRequiresSync();
        Arrays.fill(this.knownCounts, -1L);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public InventoryRequest getRequestInventory() {
        return this.requests;
    }

    @Override
    @Nullable
    protected ItemStack getNetworkRepresentation() {
        return BlockMachine.Type.LEVEL_MAINTAINER.newStack(1);
    }

    protected void tick() {
        if (!this.field_145850_b.field_72995_K) {
            this.aeGrid().ifPresent(grid -> {
                if (this.sleepTicks <= 0) {
                    boolean workDone = false;
                    ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                    for (int i = 0; i < 5; ++i) {
                        long toCraft;
                        if (!this.requests.isRequesting(i)) continue;
                        if (this.knownCounts[i] == -1L) {
                            IAEItemStack stack = (IAEItemStack)((IStorageGrid)grid.getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).getStorageList().findPrecise((IAEStack)AEItemStack.fromItemStack((ItemStack)this.requests.getStackInSlot(i)));
                            this.knownCounts[i] = stack == null ? 0L : stack.getStackSize();
                            workDone = true;
                        }
                        if (!this.crafter.isSlotOpen(i) || (toCraft = this.requests.computeDelta(i, this.knownCounts[i])) <= 0L || !this.crafter.requestCrafting(i, this.requests.request(i, toCraft), this.func_145831_w(), (IGrid)grid, crafting, this.actionSource)) continue;
                        workDone = true;
                    }
                    if (workDone) {
                        this.setDirty();
                        this.sleepTicks = 16;
                    } else {
                        this.sleepTicks = 64;
                    }
                } else {
                    --this.sleepTicks;
                }
            });
        }
    }

    public void updateWatcher(IStackWatcher watcher) {
        this.watcher = watcher;
        this.resetWatcher();
    }

    private void resetWatcher() {
        if (this.watcher != null) {
            this.watcher.reset();
            this.requests.populateWatcher(this.watcher);
        }
    }

    private void clearIndex(int index) {
        this.knownCounts[index] = -1L;
        this.resetWatcher();
    }

    public void onStackChange(IItemList<?> items, IAEStack<?> stack, IAEStack<?> delta, IActionSource actionSource, IStorageChannel<?> channel) {
        for (int i = 0; i < 5; ++i) {
            if (!this.requests.matches(i, (IAEItemStack)delta)) continue;
            this.knownCounts[i] = stack == null ? 0L : stack.getStackSize();
        }
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.crafter.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack stack, Actionable mode) {
        return this.aeGrid().map(grid -> (IAEItemStack)Platform.poweredInsert((IEnergySource)((IEnergySource)grid.getCache(IEnergyGrid.class)), (IMEInventory)((IStorageGrid)grid.getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)), (IAEStack)stack, (IActionSource)this.actionSource)).orElse(stack);
    }

    public void jobStateChange(ICraftingLink link) {
        if (this.crafter.onJobStateChange(link)) {
            this.setDirty();
        }
    }

    public void onTileSyncPacket(ByteUtils.Reader data) {
        super.onTileSyncPacket(data);
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiLevelMaintainer) {
            ((GuiLevelMaintainer)gui).updateTextBoxes(this.requests);
        }
    }

    public static class InventoryRequest
    implements ISerializable,
    IItemHandlerModifiable {
        private final TileLevelMaintainer owner;
        private final ItemStack[] requestStacks = new ItemStack[5];
        private final long[] requestQtys = new long[5];
        private final long[] requestBatches = new long[5];

        InventoryRequest(TileLevelMaintainer owner) {
            this.owner = owner;
            Arrays.fill(this.requestStacks, ItemStack.field_190927_a);
            Arrays.fill(this.requestBatches, 1L);
        }

        public long getQuantity(int index) {
            return this.requestQtys[index];
        }

        public void updateQuantity(int index, long quantity) {
            if (index >= 0 && index < 5) {
                if (quantity > 0L) {
                    if (!this.requestStacks[index].func_190926_b()) {
                        this.requestQtys[index] = quantity;
                        this.owner.setDirty();
                    }
                } else if (!this.requestStacks[index].func_190926_b()) {
                    this.requestStacks[index] = ItemStack.field_190927_a;
                    this.requestQtys[index] = 0L;
                    this.owner.clearIndex(index);
                    this.owner.setDirty();
                }
            }
        }

        public long getBatchSize(int index) {
            return this.requestBatches[index];
        }

        public void updateBatchSize(int index, long quantity) {
            if (index >= 0 && index < 5 && quantity >= 0L) {
                this.requestBatches[index] = quantity;
                this.owner.setDirty();
            }
        }

        public boolean isRequesting(int index) {
            return !this.requestStacks[index].func_190926_b();
        }

        boolean matches(int index, IAEItemStack stack) {
            return stack.isSameType(this.requestStacks[index]);
        }

        long computeDelta(int index, long existing) {
            return this.requestStacks[index].func_190926_b() ? 0L : MathUtils.clamp((long)(this.requestQtys[index] - existing), (long)0L, (long)this.requestBatches[index]);
        }

        IAEItemStack request(int index, long count) {
            AEItemStack stack = Objects.requireNonNull(AEItemStack.fromItemStack((ItemStack)this.requestStacks[index]));
            stack.setStackSize(count);
            return stack;
        }

        void populateWatcher(IStackWatcher watcher) {
            for (int i = 0; i < 5; ++i) {
                if (this.requestStacks[i].func_190926_b()) continue;
                watcher.add((IAEStack)AEItemStack.fromItemStack((ItemStack)this.requestStacks[i]));
            }
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (!this.owner.func_145831_w().field_72995_K) {
                this.requestStacks[slot] = stack;
                if (stack.func_190926_b()) {
                    this.requestQtys[slot] = 0L;
                } else {
                    this.requestQtys[slot] = stack.func_190916_E();
                    stack.func_190920_e(1);
                }
                this.owner.clearIndex(slot);
                this.owner.setDirty();
            }
        }

        public int getSlots() {
            return 5;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.requestStacks[slot];
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            throw new UnsupportedOperationException();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public void serBytes(ByteUtils.Writer data) {
            for (int i = 0; i < 5; ++i) {
                data.writeItemStack(this.requestStacks[i]);
                if (!this.requestStacks[i].func_190926_b()) {
                    data.writeLong(this.requestQtys[i]);
                }
                data.writeLong(this.requestBatches[i]);
            }
        }

        public void deserBytes(ByteUtils.Reader data) {
            for (int i = 0; i < 5; ++i) {
                this.requestStacks[i] = data.readItemStack();
                this.requestQtys[i] = this.requestStacks[i].func_190926_b() ? 0L : data.readLong();
                this.requestBatches[i] = data.readLong();
            }
        }

        public void serNBT(NBTTagCompound tag) {
            NBTTagList dtoList = new NBTTagList();
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound dto = new NBTTagCompound();
                if (!this.requestStacks[i].func_190926_b()) {
                    dto.func_74782_a("Stack", (NBTBase)this.requestStacks[i].serializeNBT());
                    dto.func_74772_a("Count", this.requestQtys[i]);
                }
                dto.func_74772_a("Batch", this.requestBatches[i]);
                dtoList.func_74742_a((NBTBase)dto);
            }
            tag.func_74782_a("Requests", (NBTBase)dtoList);
        }

        public void deserNBT(NBTTagCompound tag) {
            NBTTagList dtoList = tag.func_150295_c("Requests", 10);
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound dto = dtoList.func_150305_b(i);
                if (dto.func_74764_b("Stack")) {
                    this.requestStacks[i] = new ItemStack(dto.func_74775_l("Stack"));
                    this.requestQtys[i] = dto.func_74763_f("Count");
                } else {
                    this.requestStacks[i] = ItemStack.field_190927_a;
                    this.requestQtys[i] = 0L;
                }
                this.requestBatches[i] = dto.func_74763_f("Batch");
            }
        }
    }
}

