/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Pagination {
    private int currentPageIndex;
    private int lastPageIndex;
    private int itemsPerpage;

    public Pagination(int currentPageIndex, int listSize, int itemsPerPage) {
        this.currentPageIndex = currentPageIndex;
        this.itemsPerpage = itemsPerPage;
        this.lastPageIndex = this.getPageSize(listSize);
    }

    public void setCurrentPageIndex(int index) {
        this.currentPageIndex = index;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public int getFirstPageIndex() {
        return 0;
    }

    public int getLastPageIndex() {
        return this.lastPageIndex;
    }

    public void decrease() {
        if (this.getCurrentPageIndex() - 1 != -1) {
            this.setCurrentPageIndex(this.getCurrentPageIndex() - 1);
        }
    }

    public void increase() {
        if (this.getCurrentPageIndex() + 1 != this.getLastPageIndex() + 1) {
            this.setCurrentPageIndex(this.getCurrentPageIndex() + 1);
        }
    }

    public int getPageSize(int listSize) {
        int pageSize = listSize / this.itemsPerpage;
        int r = listSize % this.itemsPerpage;
        pageSize = r > 0 ? pageSize + 1 : pageSize;
        return pageSize > 0 ? pageSize - 1 : 0;
    }

    public void update(int currentPage, int newSize) {
        this.currentPageIndex = currentPage;
        this.lastPageIndex = this.getPageSize(newSize);
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("currentPageIndex", this.currentPageIndex);
        nbt.func_74768_a("lastPageIndex", this.lastPageIndex);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.currentPageIndex = nbt.func_74762_e("currentPageIndex");
        this.lastPageIndex = nbt.func_74762_e("lastPageIndex");
    }
}

