/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xt9.deepmoblearning.common.CommonProxy;
import xt9.deepmoblearning.common.items.IGuiItem;
import xt9.deepmoblearning.common.items.ItemBase;
import xt9.deepmoblearning.common.items.ItemDataModel;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.KeyboardHelper;

public class ItemDeepLearner
extends ItemBase
implements IGuiItem {
    public ItemDeepLearner() {
        super("deep_learner", 1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, @Nullable EnumHand hand) {
        Item mainHand = player.func_184614_ca().func_77973_b();
        Item offHand = player.func_184592_cb().func_77973_b();
        if (mainHand instanceof ItemDeepLearner || offHand instanceof ItemDeepLearner && mainHand instanceof ItemAir) {
            CommonProxy.openItemGui(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        NonNullList<ItemStack> internalDataModels = DataModel.getValidFromList(ItemDeepLearner.getContainedItems(stack));
        list.add("Will display a \u00a7bHUD\u00a77 when in mainhand or offhand");
        list.add("and populated with data models");
        if (internalDataModels.size() > 0) {
            if (!KeyboardHelper.isHoldingShift()) {
                list.add(I18n.func_135052_a((String)"deepmoblearning.holdshift", (Object[])new Object[0]));
            } else {
                list.add("Contains the following models");
                for (ItemStack dataModel : internalDataModels) {
                    if (!(dataModel.func_77973_b() instanceof ItemDataModel)) continue;
                    list.add(DataModel.getTierName(dataModel, false) + " " + dataModel.func_82833_r());
                }
            }
        }
    }

    public static NonNullList<ItemStack> getContainedItems(ItemStack deepLearner) {
        NonNullList list = NonNullList.func_191197_a((int)ItemDeepLearner.numOfInternalSlots(), (Object)ItemStack.field_190927_a);
        if (deepLearner.func_77942_o()) {
            NBTTagList inventory = deepLearner.func_77978_p().func_150295_c("inventory", 10);
            for (int i = 0; i < inventory.func_74745_c(); ++i) {
                NBTTagCompound tag = inventory.func_150305_b(i);
                list.set(i, (Object)new ItemStack(tag));
            }
        }
        return list;
    }

    public static void setContainedItems(ItemStack deepLearner, NonNullList<ItemStack> list) {
        NBTTagList inventory = new NBTTagList();
        for (ItemStack aList : list) {
            NBTTagCompound tag = new NBTTagCompound();
            aList.func_77955_b(tag);
            inventory.func_74742_a((NBTBase)tag);
        }
        deepLearner.func_77982_d(new NBTTagCompound());
        deepLearner.func_77978_p().func_74782_a("inventory", (NBTBase)inventory);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public int getGuiID() {
        return 1;
    }

    public static int numOfInternalSlots() {
        return 4;
    }
}

