/*
 * Decompiled with CFR 0.152.
 */
package portablejim.additionalresources;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.input.NullInputStream;
import portablejim.additionalresources.Ar_Reference;

public class LooseFilesResourcePack
implements IResourcePack {
    ModContainer container;

    public LooseFilesResourcePack(ModContainer container) {
        this.container = container;
    }

    private ResourceLocation stripMcMeta(ResourceLocation input) {
        String mcm = ".mcmeta";
        if (input != null && input.func_110623_a() != null && input.func_110623_a().length() > ".mcmeta".length() && input.func_110623_a().endsWith(".mcmeta")) {
            return new ResourceLocation(input.func_110624_b(), input.func_110623_a().substring(0, input.func_110623_a().length() - ".mcmeta".length()));
        }
        return input;
    }

    public InputStream func_110590_a(ResourceLocation resourceLocation) throws IOException {
        ResourceLocation strippedLocation;
        BufferedInputStream stream = new BufferedInputStream((InputStream)new NullInputStream(0L));
        try {
            strippedLocation = this.stripMcMeta(resourceLocation);
            if (!this.func_110589_b(resourceLocation) && this.func_110589_b(strippedLocation)) {
                resourceLocation = strippedLocation;
            }
            File modFolder = new File(Ar_Reference.getDataFolder(), resourceLocation.func_110624_b());
            File targetFile = new File(modFolder, resourceLocation.func_110623_a());
            stream = new BufferedInputStream(new FileInputStream(targetFile));
        }
        catch (Exception e) {
            FMLLog.getLogger().error("Error reading resource " + resourceLocation.toString());
        }
        strippedLocation = this.stripMcMeta(resourceLocation);
        if (strippedLocation != resourceLocation) {
            return this.func_110590_a(strippedLocation);
        }
        return stream;
    }

    public boolean func_110589_b(ResourceLocation resourceLocation) {
        try {
            File modFolder = new File(Ar_Reference.getDataFolder(), resourceLocation.func_110624_b());
            File targetFile = new File(modFolder, resourceLocation.func_110623_a());
            return targetFile.exists();
        }
        catch (Exception e) {
            FMLLog.getLogger().error("Error reading resource " + resourceLocation.toString());
            return false;
        }
    }

    public Set func_110587_b() {
        if (!Ar_Reference.getDataFolder().exists()) {
            Ar_Reference.getDataFolder().mkdirs();
        }
        HashSet<String> modNames = new HashSet<String>();
        try {
            File configFolder = Ar_Reference.getDataFolder();
            for (File file : configFolder.listFiles()) {
                if (!file.isDirectory()) continue;
                modNames.add(file.getName());
            }
        }
        catch (Exception e) {
            FMLLog.getLogger().error("Additional Resources: Error listing config folder files");
        }
        return modNames;
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        String fakePackMeta = "{\n  'pack': { \n    'description': 'Additional resource files',\n    'pack_format': 2\n  }\n}";
        fakePackMeta = fakePackMeta.replaceAll("'", "\"");
        JsonObject fakePackMetaJson = new JsonParser().parse(fakePackMeta).getAsJsonObject();
        return (T)metadataSerializer.func_110503_a(metadataSectionName, fakePackMetaJson);
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "Additional Resources bonus resource pack";
    }
}

