/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.reactor.IReactorProduct;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IBaseReactorComponent;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityNuclearReactorBase;
import ic2.core.fluid.FluidHandlerSteamReactor;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityNuclearSteamReactor
extends TileEntityNuclearReactorBase
implements ISteamReactor {
    private FluidTank water = new FluidTank(2000);
    private FluidTank steam = new FluidTank(20000);
    IFluidHandler fluidHandler = new FluidHandlerSteamReactor(this.water, this.steam);

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.steamReactor;
    }

    @Override
    public int getTickRate() {
        return 1;
    }

    @Override
    public void processChambers() {
        int size = this.getReactorSize();
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < size; ++x) {
                    ItemStack thing = this.getMatrixItem(x, y);
                    if (!(thing.func_77973_b() instanceof ISteamReactorComponent)) continue;
                    ISteamReactorComponent comp = (ISteamReactorComponent)thing.func_77973_b();
                    comp.processTick(this, thing, x, y, pass == 0, this.field_145850_b.func_82737_E() % 20L == 0L && pass == 1);
                }
            }
        }
    }

    @Override
    public boolean isUsefullItem(ItemStack stack, boolean insert) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (insert) {
            if (item instanceof IBaseReactorComponent) {
                return ((IBaseReactorComponent)item).canBePlacedIn(stack, this);
            }
            return false;
        }
        if (item instanceof ISteamReactorComponent) {
            return true;
        }
        if (item instanceof IReactorProduct) {
            return ((IReactorProduct)item).isProduct(stack);
        }
        return false;
    }

    @Override
    public FluidTank getWaterTank() {
        return this.water;
    }

    @Override
    public FluidTank getSteamTank() {
        return this.steam;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.water.writeToNBT(this.getTag(nbt, "WaterTank"));
        this.steam.writeToNBT(this.getTag(nbt, "SteamTank"));
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT(nbt.func_74775_l("WaterTank"));
        this.steam.readFromNBT(nbt.func_74775_l("SteamTank"));
    }

    @Override
    public void issueAchievement(EntityPlayer player) {
        IC2.achievements.issueStat(player, "steamReactorsExploded");
    }

    @Override
    public void updateReactorSize() {
        super.updateReactorSize();
        int expand = this.size - 3;
        this.water.setCapacity(2000 + expand * 1000);
        this.steam.setCapacity(20000 + expand * 5000);
    }
}

