/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import com.teamdman.animus.AnimusConfig;
import com.teamdman.animus.common.util.AnimusUtil;
import com.teamdman.animus.handlers.AnimusSoundEventHandler;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

@RitualRegister(value="ritualNaturesLeech")
public class RitualNaturesLeech
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String EFFECT_RANGE = "effect";
    public final int maxWill = 100;
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);
    public double will = 100.0;

    public RitualNaturesLeech() {
        super("ritualNaturesLeech", 0, 3000, "ritual.animus.ritualNaturesLeech");
        this.addBlockRange(ALTAR_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 24));
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 20, 20, 20);
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
    }

    public static boolean isBlacklisted(ResourceLocation resourceLocation) {
        return resourceLocation != null && RitualNaturesLeech.isBlacklisted(resourceLocation.toString());
    }

    public static boolean isBlacklisted(String registryName) {
        for (String entry : AnimusConfig.sigils.leechBlacklist) {
            if (!Objects.equals(entry, registryName)) continue;
            return true;
        }
        return false;
    }

    public void performRitual(IMasterRitualStone ritualStone) {
        World world = ritualStone.getWorldObj();
        Random random = world.field_73012_v;
        BlockPos pos = ritualStone.getBlockPos();
        EnumDemonWillType type = EnumDemonWillType.CORROSIVE;
        this.will = WorldDemonWillHandler.getCurrentWill((World)world, (BlockPos)pos, (EnumDemonWillType)type);
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)ritualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (!ritualStone.getWorldObj().field_72995_K) {
            if (currentEssence < this.getRefreshCost()) {
                network.causeNausea();
                return;
            }
            network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.leech", new Object[0]), this.getRefreshCost()));
            TileAltar tileAltar = AnimusUtil.getNearbyAltar(world, ritualStone.getBlockRange(ALTAR_RANGE), pos, this.altarOffsetPos);
            if (tileAltar == null) {
                return;
            }
            this.altarOffsetPos = tileAltar.func_174877_v();
            AreaDescriptor eatRange = ritualStone.getBlockRange(EFFECT_RANGE);
            eatRange.resetIterator();
            int randFood = 1 + random.nextInt(3);
            int eaten = 0;
            while (eatRange.hasNext() && eaten <= randFood) {
                BlockPos eatPos = ((BlockPos)eatRange.next()).func_177971_a((Vec3i)pos);
                Block eatBlock = world.func_180495_p(eatPos).func_177230_c();
                if (eatBlock == Blocks.field_150350_a || random.nextInt(100) >= 20 || !RitualNaturesLeech.isConsumable(eatBlock)) continue;
                if (world.field_72995_K) {
                    world.func_175688_a(EnumParticleTypes.SPELL, (double)eatPos.func_177958_n() + 0.5, (double)eatPos.func_177956_o() + 0.5, (double)eatPos.func_177952_p() + 0.5, (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0, new int[0]);
                }
                world.func_184133_a(null, eatPos, AnimusSoundEventHandler.naturesleech, SoundCategory.BLOCKS, 0.4f, 1.0f);
                world.func_175698_g(eatPos);
                ++eaten;
            }
            tileAltar.sacrificialDaggerCall(eaten * 50, true);
            int drainAmount = 1 + (int)(Math.random() * 5.0);
            double filled = WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)drainAmount, (double)100.0, (boolean)false);
            if (filled > 0.0) {
                WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)filled, (double)100.0, (boolean)true);
            }
        }
    }

    public static boolean isConsumable(Block block) {
        if (block == null) {
            return false;
        }
        if (block == Blocks.field_150350_a) {
            return false;
        }
        String blockName = block.func_149739_a().toLowerCase();
        if (blockName.contains("specialflower") || blockName.contains("shinyflower")) {
            return false;
        }
        if (!(block instanceof BlockLog || block instanceof IPlantable || block instanceof IShearable || block instanceof IGrowable || blockName.contains("extrabiomesxl.flower"))) {
            return false;
        }
        return !RitualNaturesLeech.isBlacklisted(block.getRegistryName());
    }

    public int getRefreshCost() {
        return 10;
    }

    public int getRefreshTime() {
        return (int)Math.min(80.0, 100.0 * (100.0 / (Math.max(1.0, this.will) * 6.0)));
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        components.accept(new RitualComponent(new BlockPos(-2, 1, -2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(-2, 1, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-2, 1, 2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -1), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(0, 1, -2), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(0, 1, 2), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(1, 0, -1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(1, 0, 1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, 1, -2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(2, 1, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, 1, 2), EnumRuneType.WATER));
    }

    public Ritual getNewCopy() {
        return new RitualNaturesLeech();
    }
}

