/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import com.google.common.base.Preconditions;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.util.Timer;

public class Animation<S extends ITransformable> {
    private S transformable;
    private Transformation<?, S> transform;
    private int delay;
    private boolean started = false;
    private boolean finished = false;
    private boolean renderBefore = true;
    private boolean renderAfter = true;

    public Animation(S transformable, Transformation<?, S> transform) {
        Preconditions.checkNotNull(transformable);
        Preconditions.checkNotNull(transform);
        this.transformable = transformable;
        this.transform = transform;
    }

    public S getTransformable() {
        return this.transformable;
    }

    public Transformation<?, S> getTransformation() {
        return this.transform;
    }

    public void setRender(boolean before, boolean after) {
        this.renderBefore = before;
        this.renderAfter = after;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean persistance() {
        return this.renderAfter;
    }

    public S animate(Timer timer) {
        long elapsed = timer.elapsedTime() - Timer.tickToTime(this.delay);
        this.started = elapsed > this.transform.getDelay();
        boolean bl = this.finished = elapsed > this.transform.totalDuration() && this.transform.getLoops() != -1;
        if (!this.started && !this.renderBefore) {
            return null;
        }
        if (this.finished && !this.renderAfter) {
            return null;
        }
        this.transform.transform(this.transformable, elapsed);
        return this.transformable;
    }
}

