/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.world;

import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.IntegerCoordinates;

public final class CoordinateUtils {
    private CoordinateUtils() {
    }

    public static DoubleCoordinates add(DoubleCoordinates coords, DoubleCoordinates toAdd) {
        coords.setXCoord(coords.getXCoord() + toAdd.getXCoord());
        coords.setYCoord(coords.getYCoord() + toAdd.getYCoord());
        coords.setZCoord(coords.getZCoord() + toAdd.getZCoord());
        return coords;
    }

    public static IntegerCoordinates add(IntegerCoordinates coords, IntegerCoordinates toAdd) {
        coords.setXCoord(coords.getXCoord() + toAdd.getXCoord());
        coords.setYCoord(coords.getYCoord() + toAdd.getYCoord());
        coords.setZCoord(coords.getZCoord() + toAdd.getZCoord());
        return coords;
    }

    public static DoubleCoordinates sum(DoubleCoordinates first, DoubleCoordinates second) {
        DoubleCoordinates ret = new DoubleCoordinates();
        ret.setXCoord(first.getXCoord() + second.getXCoord());
        ret.setYCoord(first.getYCoord() + second.getYCoord());
        ret.setZCoord(first.getZCoord() + second.getZCoord());
        return ret;
    }

    public static IntegerCoordinates sum(IntegerCoordinates first, IntegerCoordinates second) {
        IntegerCoordinates ret = new IntegerCoordinates();
        ret.setXCoord(first.getXCoord() + second.getXCoord());
        ret.setYCoord(first.getYCoord() + second.getYCoord());
        ret.setZCoord(first.getZCoord() + second.getZCoord());
        return ret;
    }

    public static DoubleCoordinates add(DoubleCoordinates coords, EnumFacing direction) {
        return CoordinateUtils.add(coords, direction, 1.0);
    }

    public static IntegerCoordinates add(IntegerCoordinates coords, EnumFacing direction) {
        return CoordinateUtils.add(coords, direction, 1);
    }

    public static DoubleCoordinates add(DoubleCoordinates coords, EnumFacing direction, double times) {
        coords.setXCoord(coords.getXCoord() + (double)direction.func_176730_m().func_177958_n() * times);
        coords.setYCoord(coords.getYCoord() + (double)direction.func_176730_m().func_177956_o() * times);
        coords.setZCoord(coords.getZCoord() + (double)direction.func_176730_m().func_177952_p() * times);
        return coords;
    }

    public static IntegerCoordinates add(IntegerCoordinates coords, EnumFacing direction, int times) {
        coords.setXCoord(coords.getXCoord() + direction.func_176730_m().func_177958_n() * times);
        coords.setYCoord(coords.getYCoord() + direction.func_176730_m().func_177956_o() * times);
        coords.setZCoord(coords.getZCoord() + direction.func_176730_m().func_177952_p() * times);
        return coords;
    }

    public static DoubleCoordinates sum(DoubleCoordinates coords, EnumFacing direction) {
        return CoordinateUtils.sum(coords, direction, 1.0);
    }

    public static IntegerCoordinates sum(IntegerCoordinates coords, EnumFacing direction) {
        return CoordinateUtils.sum(coords, direction, 1);
    }

    public static DoubleCoordinates sum(DoubleCoordinates coords, EnumFacing direction, double times) {
        DoubleCoordinates ret = new DoubleCoordinates(coords);
        return CoordinateUtils.add(ret, direction, times);
    }

    public static IntegerCoordinates sum(IntegerCoordinates coords, EnumFacing direction, int times) {
        IntegerCoordinates ret = new IntegerCoordinates(coords);
        return CoordinateUtils.add(ret, direction, times);
    }

    public static EnumFacing getDirectionFromTo(DoubleCoordinates source, DoubleCoordinates target) {
        double xDiff = target.getXCoord() - source.getXCoord();
        double yDiff = target.getYCoord() - source.getYCoord();
        double zDiff = target.getZCoord() - source.getZCoord();
        if (xDiff != 0.0 && yDiff == 0.0 && zDiff == 0.0) {
            if (xDiff > 0.0) {
                return EnumFacing.EAST;
            }
            return EnumFacing.WEST;
        }
        if (xDiff == 0.0 && yDiff != 0.0 && zDiff == 0.0) {
            if (yDiff > 0.0) {
                return EnumFacing.UP;
            }
            return EnumFacing.DOWN;
        }
        if (xDiff == 0.0 && yDiff == 0.0 && zDiff != 0.0) {
            if (zDiff > 0.0) {
                return EnumFacing.SOUTH;
            }
            return EnumFacing.NORTH;
        }
        return null;
    }
}

