/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui.extention;

import java.util.ArrayList;
import java.util.List;

public abstract class GuiExtention {
    private boolean extending;
    private int currentW = this.getMinimumWidth();
    private int currentH = this.getMinimumHeight();
    private int currentXPos = 0;
    private int currentYPos = 0;
    private int targetYPos = 0;
    private boolean init = true;
    private List<Integer> slotList = new ArrayList<Integer>();
    private List<Integer> buttonList = new ArrayList<Integer>();

    public abstract int getFinalWidth();

    public abstract int getFinalHeight();

    public abstract void renderForground(int var1, int var2);

    public final void update(int xPos, int yPos) {
        this.currentXPos = xPos;
        this.currentYPos = yPos > this.currentYPos + 1 && !this.init ? (this.currentYPos += 2) : (yPos < this.currentYPos - 1 && !this.init ? (this.currentYPos -= 2) : yPos);
        this.targetYPos = yPos;
        this.init = false;
        if (this.extending) {
            this.currentH = this.currentH < this.getFinalHeight() ? (this.currentH += 4) : this.getFinalHeight();
            this.currentW = this.currentW < this.getFinalWidth() ? (this.currentW += 2) : this.getFinalWidth();
        } else {
            this.currentH = this.currentH > this.getMinimumHeight() ? (this.currentH -= 4) : this.getMinimumHeight();
            this.currentW = this.currentW > this.getMinimumWidth() ? (this.currentW -= 2) : this.getMinimumWidth();
        }
    }

    public int getMinimumWidth() {
        return 23;
    }

    public int getMinimumHeight() {
        return 26;
    }

    public int getCurrentWidth() {
        return this.currentW;
    }

    public int getCurrentHeight() {
        return this.currentH;
    }

    public boolean isFullyExtended() {
        return this.currentW == this.getFinalWidth() && this.currentH == this.getFinalHeight() && this.targetYPos == this.currentYPos;
    }

    public boolean isFullyRetracted() {
        return this.currentW == this.getMinimumWidth() && this.currentH == this.getMinimumHeight() && this.targetYPos == this.currentYPos;
    }

    public void handleMouseOverAt(int xPos, int yPos) {
    }

    public void registerSlot(int id) {
        this.slotList.add(id);
    }

    public boolean renderSlot(int id) {
        return this.slotList.contains(id);
    }

    public boolean renderSelectSlot(int id) {
        return this.slotList.contains(id);
    }

    public void registerButton(int id) {
        this.buttonList.add(id);
    }

    public boolean renderButton(int id) {
        return this.buttonList.contains(id);
    }

    public boolean isExtending() {
        return this.extending;
    }

    GuiExtention setExtending(boolean extending) {
        this.extending = extending;
        return this;
    }

    public int getCurrentXPos() {
        return this.currentXPos;
    }

    public int getCurrentYPos() {
        return this.currentYPos;
    }
}

