/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;

public class ReflectionHelper {
    private static final Map<Triplet<Class<?>, String, List<Class<?>>>, Method> methodCache = new HashMap();
    private static final Map<Pair<Class<?>, String>, Field> fieldCache = new HashMap();

    public static <T> T invokePrivateMethod(Class<?> clazz, Object target, String name, String srgName, Class<?>[] classes, Object[] objects) {
        Triplet key = new Triplet(clazz, name, Arrays.asList(classes));
        Method method = methodCache.get(key);
        if (method == null) {
            try {
                method = clazz.getDeclaredMethod(name, classes);
            }
            catch (NoSuchMethodException e1) {
                try {
                    method = clazz.getMethod(name, classes);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        method = clazz.getDeclaredMethod(srgName, classes);
                    }
                    catch (NoSuchMethodException e3) {
                        try {
                            method = clazz.getMethod(srgName, classes);
                        }
                        catch (NoSuchMethodException e4) {
                            method = clazz.getDeclaredMethod(name, classes);
                        }
                    }
                }
            }
            method.setAccessible(true);
            methodCache.put(key, method);
        }
        Object result = method.invoke(target, objects);
        return (T)result;
    }

    public static <T> T getPrivateField(Class<?> clazz, Object target, String name, String srgName) {
        Field field = ReflectionHelper.getField(clazz, name, srgName);
        Object result = field.get(target);
        return (T)result;
    }

    public static void setPrivateField(Class<?> clazz, Object target, String name, String srgName, Object value) {
        Field field = ReflectionHelper.getField(clazz, name, srgName);
        field.set(target, value);
    }

    private static Field getField(Class<?> clazz, String name, String srgName) throws NoSuchFieldException {
        Pair key = new Pair(clazz, name);
        Field field = fieldCache.get(key);
        if (field == null) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e1) {
                try {
                    field = clazz.getField(name);
                }
                catch (NoSuchFieldException e2) {
                    try {
                        field = clazz.getDeclaredField(srgName);
                    }
                    catch (NoSuchFieldException e3) {
                        try {
                            field = clazz.getField(srgName);
                        }
                        catch (NoSuchFieldException e4) {
                            field = clazz.getDeclaredField(name);
                        }
                    }
                }
            }
            field.setAccessible(true);
            fieldCache.put(key, field);
        }
        return field;
    }
}

