/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.channels;

import java.util.UUID;
import logisticspipes.utils.PlayerIdentifier;
import lombok.NonNull;
import net.minecraft.nbt.NBTTagCompound;

public class ChannelInformation {
    private String name;
    @NonNull
    private final UUID channelIdentifier;
    @NonNull
    private PlayerIdentifier owner;
    @NonNull
    private AccessRights rights;
    private UUID responsibleSecurityID;

    public ChannelInformation(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.channelIdentifier = UUID.fromString(nbt.func_74779_i("channelIdentifier"));
        this.owner = PlayerIdentifier.readFromNBT(nbt, "owner");
        this.rights = AccessRights.values()[nbt.func_74762_e("rights")];
        this.responsibleSecurityID = nbt.func_74764_b("responsibleSecurityID") ? UUID.fromString(nbt.func_74779_i("responsibleSecurityID")) : null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("channelIdentifier", this.channelIdentifier.toString());
        this.owner.writeToNBT(compound, "owner");
        compound.func_74768_a("rights", this.rights.ordinal());
        if (this.responsibleSecurityID != null) {
            compound.func_74778_a("responsibleSecurityID", this.responsibleSecurityID.toString());
        }
        return compound;
    }

    public String getName() {
        return this.name;
    }

    @NonNull
    public UUID getChannelIdentifier() {
        return this.channelIdentifier;
    }

    @NonNull
    public PlayerIdentifier getOwner() {
        return this.owner;
    }

    @NonNull
    public AccessRights getRights() {
        return this.rights;
    }

    public UUID getResponsibleSecurityID() {
        return this.responsibleSecurityID;
    }

    public ChannelInformation setName(String name) {
        this.name = name;
        return this;
    }

    public ChannelInformation setOwner(@NonNull PlayerIdentifier owner) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        this.owner = owner;
        return this;
    }

    public ChannelInformation setRights(@NonNull AccessRights rights) {
        if (rights == null) {
            throw new NullPointerException("rights is marked non-null but is null");
        }
        this.rights = rights;
        return this;
    }

    public ChannelInformation setResponsibleSecurityID(UUID responsibleSecurityID) {
        this.responsibleSecurityID = responsibleSecurityID;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelInformation)) {
            return false;
        }
        ChannelInformation other = (ChannelInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$channelIdentifier = this.getChannelIdentifier();
        UUID other$channelIdentifier = other.getChannelIdentifier();
        if (this$channelIdentifier == null ? other$channelIdentifier != null : !((Object)this$channelIdentifier).equals(other$channelIdentifier)) {
            return false;
        }
        PlayerIdentifier this$owner = this.getOwner();
        PlayerIdentifier other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        AccessRights this$rights = this.getRights();
        AccessRights other$rights = other.getRights();
        if (this$rights == null ? other$rights != null : !((Object)((Object)this$rights)).equals((Object)other$rights)) {
            return false;
        }
        UUID this$responsibleSecurityID = this.getResponsibleSecurityID();
        UUID other$responsibleSecurityID = other.getResponsibleSecurityID();
        return !(this$responsibleSecurityID == null ? other$responsibleSecurityID != null : !((Object)this$responsibleSecurityID).equals(other$responsibleSecurityID));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $channelIdentifier = this.getChannelIdentifier();
        result = result * 59 + ($channelIdentifier == null ? 43 : ((Object)$channelIdentifier).hashCode());
        PlayerIdentifier $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        AccessRights $rights = this.getRights();
        result = result * 59 + ($rights == null ? 43 : ((Object)((Object)$rights)).hashCode());
        UUID $responsibleSecurityID = this.getResponsibleSecurityID();
        result = result * 59 + ($responsibleSecurityID == null ? 43 : ((Object)$responsibleSecurityID).hashCode());
        return result;
    }

    public String toString() {
        return "ChannelInformation(name=" + this.getName() + ", channelIdentifier=" + this.getChannelIdentifier() + ", owner=" + this.getOwner() + ", rights=" + (Object)((Object)this.getRights()) + ", responsibleSecurityID=" + this.getResponsibleSecurityID() + ")";
    }

    public ChannelInformation(String name, @NonNull UUID channelIdentifier, @NonNull PlayerIdentifier owner, @NonNull AccessRights rights, UUID responsibleSecurityID) {
        if (channelIdentifier == null) {
            throw new NullPointerException("channelIdentifier is marked non-null but is null");
        }
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (rights == null) {
            throw new NullPointerException("rights is marked non-null but is null");
        }
        this.name = name;
        this.channelIdentifier = channelIdentifier;
        this.owner = owner;
        this.rights = rights;
        this.responsibleSecurityID = responsibleSecurityID;
    }

    public static enum AccessRights {
        PRIVATE,
        SECURED,
        PUBLIC;

    }
}

