/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.ExitRouteDebug;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.LPFinalSerializable;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class ExitRoute
implements Comparable<ExitRoute>,
LPFinalSerializable {
    public final double destinationDistanceToRoot;
    public final int blockDistance;
    public final EnumSet<PipeRoutingConnectionType> connectionDetails;
    @Nonnull
    public final IRouter destination;
    public EnumFacing exitOrientation;
    public EnumFacing insertOrientation;
    public double distanceToDestination;
    public IRouter root;
    public List<IFilter> filters = Collections.unmodifiableList(new ArrayList(0));
    public ExitRouteDebug debug = new ExitRouteDebug();

    public ExitRoute(@Nullable IRouter source, @Nonnull IRouter destination, @Nullable EnumFacing exitOrientation, @Nullable EnumFacing insertOrientation, double metric, EnumSet<PipeRoutingConnectionType> connectionDetails, int blockDistance) {
        this.destination = destination;
        this.root = source;
        this.exitOrientation = exitOrientation;
        this.insertOrientation = insertOrientation;
        this.connectionDetails = connectionDetails;
        this.distanceToDestination = connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) ? metric : 2.147483647E9;
        this.destinationDistanceToRoot = connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom) ? metric : 2.147483647E9;
        this.blockDistance = blockDistance;
    }

    @SideOnly(value=Side.CLIENT)
    public ExitRoute(LPDataInput input) {
        if (!input.readBoolean()) {
            throw new RuntimeException("Cannot read an ExitRoute without destination");
        }
        IRouter destinationRouter = this.readRouter(input);
        if (destinationRouter == null) {
            throw new RuntimeException("Destination of the ExitRoute could not be determined");
        }
        this.destination = destinationRouter;
        this.root = input.readBoolean() ? this.readRouter(input) : null;
        this.exitOrientation = input.readFacing();
        this.insertOrientation = input.readFacing();
        this.connectionDetails = input.readEnumSet(PipeRoutingConnectionType.class);
        this.distanceToDestination = input.readDouble();
        double metric = input.readDouble();
        if (!this.connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom)) {
            metric = 2.147483647E9;
        }
        this.destinationDistanceToRoot = metric;
        this.blockDistance = input.readInt();
        this.debug.filterPosition = input.readArrayList(DoubleCoordinates::new);
        this.debug.toStringNetwork = input.readUTF();
        this.debug.isNewlyAddedCanidate = input.readBoolean();
        this.debug.isTraced = input.readBoolean();
        this.debug.index = input.readInt();
    }

    public ExitRoute(IRouter source, IRouter destination, double distance, EnumSet<PipeRoutingConnectionType> enumSet, List<IFilter> filterA, List<IFilter> filterB, int blockDistance) {
        this(source, destination, null, null, distance, enumSet, blockDistance);
        ArrayList<IFilter> filter = new ArrayList<IFilter>(filterA.size() + filterB.size());
        filter.addAll(filterA);
        filter.addAll(filterB);
        this.filters = Collections.unmodifiableList(filter);
    }

    @SideOnly(value=Side.CLIENT)
    private IRouter readRouter(LPDataInput input) {
        DoubleCoordinates pos = new DoubleCoordinates(input);
        TileEntity tile = pos.getTileEntity((IBlockAccess)MainProxy.getClientMainWorld());
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe) {
            return ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).getRouter();
        }
        return null;
    }

    @Override
    public void write(LPDataOutput output) {
        output.writeBoolean(true);
        this.destination.write(output);
        if (this.root == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            this.root.write(output);
        }
        output.writeFacing(this.exitOrientation);
        output.writeFacing(this.insertOrientation);
        output.writeEnumSet(this.connectionDetails, PipeRoutingConnectionType.class);
        output.writeDouble(this.distanceToDestination);
        output.writeDouble(this.destinationDistanceToRoot);
        output.writeInt(this.blockDistance);
        output.writeCollection(this.filters, (innerOutput, filter) -> innerOutput.writeSerializable(filter.getLPPosition()));
        output.writeUTF(this.toString());
        output.writeBoolean(this.debug.isNewlyAddedCanidate);
        output.writeBoolean(this.debug.isTraced);
        output.writeInt(this.debug.index);
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof ExitRoute)) {
            return false;
        }
        ExitRoute that = (ExitRoute)aThat;
        return this.exitOrientation.equals((Object)that.exitOrientation) && this.insertOrientation.equals((Object)that.insertOrientation) && this.connectionDetails.equals(that.connectionDetails) && this.distanceToDestination == that.distanceToDestination && this.destinationDistanceToRoot == that.destinationDistanceToRoot && this.destination == that.destination && this.filters.equals(that.filters);
    }

    public boolean isSameWay(ExitRoute that) {
        if (this.equals(that)) {
            return true;
        }
        return this.connectionDetails.equals(that.connectionDetails) && this.destination == that.destination && this.filters.equals(that.filters);
    }

    public String toString() {
        return "{" + this.exitOrientation.name() + "," + this.insertOrientation.name() + "," + this.distanceToDestination + "," + this.destinationDistanceToRoot + ", ConnectionDetails: " + this.connectionDetails + ", " + this.filters + "}";
    }

    public void removeFlags(EnumSet<PipeRoutingConnectionType> flags) {
        this.connectionDetails.removeAll(flags);
    }

    public boolean containsFlag(PipeRoutingConnectionType flag) {
        return this.connectionDetails.contains((Object)flag);
    }

    public boolean hasActivePipe() {
        return this.destination.getCachedPipe() != null;
    }

    public EnumSet<PipeRoutingConnectionType> getFlags() {
        return EnumSet.copyOf(this.connectionDetails);
    }

    public Set<PipeRoutingConnectionType> getFlagsNoCopy() {
        return Collections.unmodifiableSet(this.connectionDetails);
    }

    @Override
    public int compareTo(ExitRoute o) {
        int c = (int)Math.floor(this.distanceToDestination - o.distanceToDestination);
        if (c == 0) {
            return this.destination.getSimpleID() - o.destination.getSimpleID();
        }
        return c;
    }
}

