/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe.tube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.tubes.HSTubeGain;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IBounds;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.RenderEntry;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class GainTubeRenderer
implements ISpecialPipeRenderer,
IHighlightPlacementRenderer {
    public static final GainTubeRenderer instance = new GainTubeRenderer();
    static Map<HSTubeGain.TubeGainRenderOrientation, List<IModel3D>> tubeTurnBase = new HashMap<HSTubeGain.TubeGainRenderOrientation, List<IModel3D>>();
    static Map<HSTubeGain.TubeGainRenderOrientation, Map<Pair<TubeMount, Integer>, IModel3D>> tubeTurnMounts = new HashMap<HSTubeGain.TubeGainRenderOrientation, Map<Pair<TubeMount, Integer>, IModel3D>>();
    public static Map<HSTubeGain.TubeGainRenderOrientation, IModel3D> tubeGain = new HashMap<HSTubeGain.TubeGainRenderOrientation, IModel3D>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/blocks/pipes/HS-Tube.png");

    private GainTubeRenderer() {
    }

    public static void loadModels() {
        try {
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/HSTube-Gain_result.obj"), 7, new LPScale(0.01f));
            for (HSTubeGain.TubeGainRenderOrientation turn : HSTubeGain.TubeGainRenderOrientation.values()) {
                tubeTurnBase.put(turn, new ArrayList());
            }
            pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Lane ") || ((String)entry.getKey()).contains(" Lane ") || ((String)entry.getKey()).endsWith(" Lane")).forEach(entry -> {
                tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.EAST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 0.0)).apply(new LPRotation(-1.5707963267948966, 0, 1, 0))));
                tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.NORTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.WEST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 1.0)).apply(new LPRotation(1.5707963267948966, 0, 1, 0))));
                tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.SOUTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 0.0)).apply(new LPRotation(Math.PI, 0, 1, 0))));
            });
            if (tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.NORTH).size() != 4) {
                throw new RuntimeException("Couldn't load Tube Lanes. Only loaded " + tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.NORTH).size());
            }
            for (HSTubeGain.TubeGainRenderOrientation turn : HSTubeGain.TubeGainRenderOrientation.values()) {
                tubeGain.put(turn, SimpleServiceLocator.cclProxy.combine((Collection<IModel3D>)tubeTurnBase.get(turn)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void renderToList(CoreUnroutedPipe pipe, List<RenderEntry> objectsToRender) {
        HSTubeGain tube;
        if (pipe instanceof HSTubeGain && (tube = (HSTubeGain)pipe).getOrientation() != null) {
            objectsToRender.addAll(tubeTurnBase.get(tube.getOrientation().getRenderOrientation()).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
        if (pipe == null) {
            objectsToRender.addAll(tubeTurnBase.get(HSTubeGain.TubeGainRenderOrientation.NORTH).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        tubeGain.get(orientation.getRenderOrientation()).copy().render(LPColourMultiplier.instance(-1));
    }

    public static AxisAlignedBB getObjectBoundsAt(AxisAlignedBB boundingBox, ITubeOrientation orientation) {
        IModel3D model = tubeGain.get(orientation.getRenderOrientation());
        IBounds c = model.getBoundsInside(boundingBox);
        if (c != null) {
            return c.toAABB();
        }
        return null;
    }

    static {
        GainTubeRenderer.loadModels();
    }

    static enum TubeMount {
        UP_LEFT,
        UP_RIGHT,
        DOWN_LEFT,
        DOWN_RIGHT;

    }
}

