/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import java.lang.reflect.Field;
import logisticspipes.LogisticsPipes;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.SlotFinderNumberPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.SimpleGraphics;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LogisticsGuiOverrenderer {
    private static LogisticsGuiOverrenderer instance = new LogisticsGuiOverrenderer();
    private int oldX;
    private int oldY;
    private boolean hasBeenSaved;
    private boolean clicked;
    private Field fX;
    private Field fY;
    private int targetPosX;
    private int targetPosY;
    private int targetPosZ;
    private int pipePosX;
    private int pipePosY;
    private int pipePosZ;
    private LogisticsModule.ModulePositionType positionType;
    private int positionInt;
    private int slot;
    private boolean isOverlaySlotActive;

    private LogisticsGuiOverrenderer() {
        block2: {
            try {
                this.fX = Mouse.class.getDeclaredField("x");
                this.fY = Mouse.class.getDeclaredField("y");
                this.fX.setAccessible(true);
                this.fY.setAccessible(true);
            }
            catch (Exception e) {
                if (!LogisticsPipes.isDEBUG()) break block2;
                e.printStackTrace();
            }
        }
    }

    public boolean isCompatibleGui() {
        if (FMLClientHandler.instance() == null) {
            return false;
        }
        if (FMLClientHandler.instance().getClient() == null) {
            return false;
        }
        return FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer;
    }

    public void preRender() {
        if (this.isOverlaySlotActive) {
            block4: {
                this.oldX = Mouse.getX();
                this.oldY = Mouse.getY();
                try {
                    this.fX.set(null, 0);
                    this.fY.set(null, 0);
                    this.hasBeenSaved = true;
                }
                catch (Exception e) {
                    if (!LogisticsPipes.isDEBUG()) break block4;
                    e.printStackTrace();
                }
            }
            while (Mouse.next()) {
                if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState()) continue;
                this.clicked = true;
            }
        }
    }

    public void renderOverGui() {
        block5: {
            if (this.hasBeenSaved) {
                this.hasBeenSaved = false;
                try {
                    this.fX.set(null, this.oldX);
                    this.fY.set(null, this.oldY);
                }
                catch (Exception e) {
                    if (!LogisticsPipes.isDEBUG()) break block5;
                    e.printStackTrace();
                }
            }
        }
        if (this.isOverlaySlotActive) {
            GuiContainer gui = (GuiContainer)FMLClientHandler.instance().getClient().field_71462_r;
            int guiTop = gui.getGuiTop();
            int guiLeft = gui.getGuiLeft();
            int x = this.oldX * gui.field_146294_l / FMLClientHandler.instance().getClient().field_71443_c;
            int y = gui.field_146295_m - this.oldY * gui.field_146295_m / FMLClientHandler.instance().getClient().field_71440_d - 1;
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                if (!this.isMouseOverSlot(gui, slot, x, y)) continue;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glTranslated((double)guiLeft, (double)guiTop, (double)0.0);
                int k1 = slot.field_75223_e;
                int i1 = slot.field_75221_f;
                SimpleGraphics.drawGradientRect(k1, i1, k1 + 16, i1 + 16, -1593901056, -1593901056, 0.0);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                if (!this.clicked) break;
                MainProxy.sendPacketToServer(PacketHandler.getPacket(SlotFinderNumberPacket.class).setInventorySlot(slot.field_75222_d).setSlot(this.slot).setPipePosX(this.pipePosX).setPipePosY(this.pipePosY).setPipePosZ(this.pipePosZ).setType(this.positionType).setPositionInt(this.positionInt).setPosX(this.targetPosX).setPosY(this.targetPosY).setPosZ(this.targetPosZ));
                this.clicked = false;
                FMLClientHandler.instance().getClient().field_71439_g.func_71053_j();
                this.isOverlaySlotActive = false;
                break;
            }
            this.clicked = false;
        }
    }

    private boolean isMouseOverSlot(GuiContainer gui, Slot slot, int mouseX, int mouseY) {
        return this.isPointInRegion(gui, slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    private boolean isPointInRegion(GuiContainer gui, int x, int y, int width, int height, int pointX, int pointY) {
        int x0 = gui.getGuiLeft();
        int y0 = gui.getGuiTop();
        return (pointX -= x0) >= x - 1 && pointX < x + width + 1 && (pointY -= y0) >= y - 1 && pointY < y + height + 1;
    }

    public static LogisticsGuiOverrenderer getInstance() {
        return instance;
    }

    public LogisticsGuiOverrenderer setTargetPosX(int targetPosX) {
        this.targetPosX = targetPosX;
        return this;
    }

    public LogisticsGuiOverrenderer setTargetPosY(int targetPosY) {
        this.targetPosY = targetPosY;
        return this;
    }

    public LogisticsGuiOverrenderer setTargetPosZ(int targetPosZ) {
        this.targetPosZ = targetPosZ;
        return this;
    }

    public LogisticsGuiOverrenderer setPipePosX(int pipePosX) {
        this.pipePosX = pipePosX;
        return this;
    }

    public LogisticsGuiOverrenderer setPipePosY(int pipePosY) {
        this.pipePosY = pipePosY;
        return this;
    }

    public LogisticsGuiOverrenderer setPipePosZ(int pipePosZ) {
        this.pipePosZ = pipePosZ;
        return this;
    }

    public LogisticsGuiOverrenderer setPositionType(LogisticsModule.ModulePositionType positionType) {
        this.positionType = positionType;
        return this;
    }

    public LogisticsGuiOverrenderer setPositionInt(int positionInt) {
        this.positionInt = positionInt;
        return this;
    }

    public LogisticsGuiOverrenderer setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    public LogisticsGuiOverrenderer setOverlaySlotActive(boolean isOverlaySlotActive) {
        this.isOverlaySlotActive = isOverlaySlotActive;
        return this;
    }
}

