/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import buildcraft.api.inventory.IItemTransactor;
import buildcraft.lib.misc.CapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class BuildCraftTransactorHandler
extends SpecialInventoryHandler {
    private IItemTransactor cap = null;

    private BuildCraftTransactorHandler(IItemTransactor cap) {
        this.cap = cap;
    }

    public BuildCraftTransactorHandler() {
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile, EnumFacing dir) {
        return tile.hasCapability(CapUtil.CAP_ITEM_TRANSACTOR, dir);
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        IItemTransactor cap = (IItemTransactor)tile.getCapability(CapUtil.CAP_ITEM_TRANSACTOR, dir);
        if (cap != null) {
            return new BuildCraftTransactorHandler(cap);
        }
        return null;
    }

    @Override
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier item) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        return this.cap.insert(item.makeNormalStack(64), false, true).func_190916_E();
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        return Collections.emptySet();
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.cap.extract(it -> true, 0, 64, true);
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int slot, int amount) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.cap.extract(it -> true, amount, amount, false);
    }

    @Override
    public ItemStack add(ItemStack stack, EnumFacing orientation, boolean doAdd) {
        ItemStack overflow = this.cap.insert(stack.func_77946_l(), false, !doAdd);
        stack.func_190920_e(stack.func_190916_E() - overflow.func_190916_E());
        return stack;
    }
}

