/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.interfaces.IClientState;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataIOWrapper;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PipeTileStatePacket
extends CoordinatesPacket {
    private IClientState renderState;
    private IClientState coreState;
    private IClientState pipe;
    private byte[] bytesRenderState;
    private byte[] bytesCoreState;
    private byte[] bytesPipe;
    private int statePacketId;

    public PipeTileStatePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.NONE);
        if (pipe == null) {
            return;
        }
        if (pipe.statePacketId < this.statePacketId) {
            LPDataIOWrapper.provideData(this.bytesRenderState, pipe.renderState::readData);
            LPDataIOWrapper.provideData(this.bytesCoreState, pipe.coreState::readData);
            pipe.afterStateUpdated();
            if (pipe.pipe != null) {
                LPDataIOWrapper.provideData(this.bytesPipe, pipe.pipe::readData);
                pipe.statePacketId = this.statePacketId;
            }
        }
    }

    @Override
    public ModernPacket template() {
        return new PipeTileStatePacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        IClientState[] clientStates = new IClientState[]{this.renderState, this.coreState, this.pipe};
        byte[][] clientStateBuffers = new byte[][]{this.bytesRenderState, this.bytesCoreState, this.bytesPipe};
        for (int i = 0; i < clientStates.length; ++i) {
            clientStateBuffers[i] = LPDataIOWrapper.collectData(clientStates[i]::writeData);
            output.writeByteArray(clientStateBuffers[i]);
        }
        output.writeInt(this.statePacketId);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.bytesRenderState = input.readByteArray();
        this.bytesCoreState = input.readByteArray();
        this.bytesPipe = input.readByteArray();
        this.statePacketId = input.readInt();
    }

    public PipeTileStatePacket setRenderState(IClientState renderState) {
        this.renderState = renderState;
        return this;
    }

    public PipeTileStatePacket setCoreState(IClientState coreState) {
        this.coreState = coreState;
        return this;
    }

    public PipeTileStatePacket setPipe(IClientState pipe) {
        this.pipe = pipe;
        return this;
    }

    public byte[] getBytesRenderState() {
        return this.bytesRenderState;
    }

    public byte[] getBytesCoreState() {
        return this.bytesCoreState;
    }

    public byte[] getBytesPipe() {
        return this.bytesPipe;
    }

    public int getStatePacketId() {
        return this.statePacketId;
    }

    public PipeTileStatePacket setStatePacketId(int statePacketId) {
        this.statePacketId = statePacketId;
        return this;
    }
}

