/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.interfaces.ISpawnParticles;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.utils.StaticResolve;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ParticleFX
extends CoordinatesPacket {
    @NonNull
    private Collection<ISpawnParticles.ParticleCount> particles;

    public ParticleFX(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ParticleFX(this.getId());
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        int nparticles = input.readInt();
        this.particles = new ArrayList<ISpawnParticles.ParticleCount>(nparticles);
        for (int i = 0; i < nparticles; ++i) {
            byte particle = input.readByte();
            int amount = input.readInt();
            this.particles.add(new ISpawnParticles.ParticleCount(Particles.values()[particle], amount));
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.particles.size());
        for (ISpawnParticles.ParticleCount pc : this.particles) {
            output.writeByte(pc.getParticle().ordinal());
            output.writeInt(pc.getAmount());
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (!Minecraft.func_71375_t()) {
            return;
        }
        for (ISpawnParticles.ParticleCount pc : this.particles) {
            PipeFXRenderHandler.spawnGenericParticle(pc.getParticle(), this.getPosX(), this.getPosY(), this.getPosZ(), pc.getAmount());
        }
    }

    @NonNull
    public Collection<ISpawnParticles.ParticleCount> getParticles() {
        return this.particles;
    }

    public ParticleFX setParticles(@NonNull Collection<ISpawnParticles.ParticleCount> particles) {
        if (particles == null) {
            throw new NullPointerException("particles is marked non-null but is null");
        }
        this.particles = particles;
        return this;
    }
}

