/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.module;

import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.gui.GuiSupplierPipe;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SupplierPipeLimitedPacket
extends ModuleCoordinatesPacket {
    private boolean isLimited;

    public SupplierPipeLimitedPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ModuleActiveSupplier module = this.getLogisticsModule(player, ModuleActiveSupplier.class);
        if (module == null) {
            return;
        }
        module.setLimited(this.isLimited());
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            this.refresh();
        } else {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SupplierPipeLimitedPacket.class).setLimited(this.isLimited()).setPacketPos(this), player);
        }
    }

    @ClientSideOnlyMethodContent
    private void refresh() {
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiSupplierPipe) {
            ((GuiSupplierPipe)FMLClientHandler.instance().getClient().field_71462_r).refreshMode();
        }
    }

    @Override
    public ModernPacket template() {
        return new SupplierPipeLimitedPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.isLimited);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.isLimited = input.readBoolean();
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public SupplierPipeLimitedPacket setLimited(boolean isLimited) {
        this.isLimited = isLimited;
        return this;
    }
}

