/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.ColorSlot;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.DummySlot;
import logisticspipes.utils.gui.FluidSlot;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class DummyContainerSlotClick
extends ModernPacket {
    int slotId;
    ItemStack stack;
    int button;

    public DummyContainerSlotClick(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.slotId = input.readInt();
        this.stack = input.readItemIdentifierStack().makeNormalStack();
        this.button = input.readInt();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71070_bA instanceof DummyContainer) {
            DummyContainer container = (DummyContainer)((EntityPlayerMP)player).field_71070_bA;
            Slot slot = (Slot)container.field_75151_b.get(this.slotId);
            if (slot instanceof DummySlot || slot instanceof ColorSlot || slot instanceof FluidSlot) {
                container.handleDummyClick(slot, this.slotId, this.stack, this.button, ClickType.PICKUP, player);
            }
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.slotId);
        output.writeItemIdentifierStack(ItemIdentifierStack.getFromStack(this.stack));
        output.writeInt(this.button);
    }

    @Override
    public ModernPacket template() {
        return new DummyContainerSlotClick(this.getId());
    }

    public int getSlotId() {
        return this.slotId;
    }

    public DummyContainerSlotClick setSlotId(int slotId) {
        this.slotId = slotId;
        return this;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public DummyContainerSlotClick setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public int getButton() {
        return this.button;
    }

    public DummyContainerSlotClick setButton(int button) {
        this.button = button;
        return this;
    }
}

