/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CompilerTriggerTaskPacket
extends CoordinatesPacket {
    private ResourceLocation category;
    private String type;

    public CompilerTriggerTaskPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsProgramCompilerTileEntity tile = this.getTile(player.field_70170_p, LogisticsProgramCompilerTileEntity.class);
        tile.triggerNewTask(this.getCategory(), this.getType());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeResourceLocation(this.category);
        output.writeUTF(this.type);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.category = input.readResourceLocation();
        this.type = input.readUTF();
    }

    @Override
    public ModernPacket template() {
        return new CompilerTriggerTaskPacket(this.getId());
    }

    public ResourceLocation getCategory() {
        return this.category;
    }

    public CompilerTriggerTaskPacket setCategory(ResourceLocation category) {
        this.category = category;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CompilerTriggerTaskPacket setType(String type) {
        this.type = type;
        return this;
    }
}

