/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.util.UUID;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class AddNewChannelPacket
extends ModernPacket {
    private String name;
    private ChannelInformation.AccessRights rights;
    private UUID securityStationID;

    public AddNewChannelPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.name = input.readUTF();
        this.rights = input.readEnum(ChannelInformation.AccessRights.class);
        this.securityStationID = input.readUUID();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeUTF(this.name);
        output.writeEnum(this.rights);
        output.writeUUID(this.securityStationID);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        IChannelManager manager = SimpleServiceLocator.channelManagerProvider.getChannelManager(player.func_130014_f_());
        manager.createNewChannel(this.name, PlayerIdentifier.get(player), this.rights, this.securityStationID);
    }

    @Override
    public ModernPacket template() {
        return new AddNewChannelPacket(this.getId());
    }

    public String getName() {
        return this.name;
    }

    public AddNewChannelPacket setName(String name) {
        this.name = name;
        return this;
    }

    public ChannelInformation.AccessRights getRights() {
        return this.rights;
    }

    public AddNewChannelPacket setRights(ChannelInformation.AccessRights rights) {
        this.rights = rights;
        return this;
    }

    public UUID getSecurityStationID() {
        return this.securityStationID;
    }

    public AddNewChannelPacket setSecurityStationID(UUID securityStationID) {
        this.securityStationID = securityStationID;
        return this;
    }
}

