/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.block;

import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.gui.GuiLogisticsCraftingTable;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class AutoCraftingGui
extends CoordinatesGuiProvider {
    boolean isFuzzy;
    boolean[] ignore_dmg = new boolean[9];
    boolean[] ignore_nbt = new boolean[9];
    boolean[] use_od = new boolean[9];
    boolean[] use_category = new boolean[9];
    ItemIdentifier targetType;

    public AutoCraftingGui(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        LogisticsCraftingTableTileEntity tile = this.getTile(player.func_130014_f_(), LogisticsCraftingTableTileEntity.class);
        if (tile == null) {
            return null;
        }
        if (tile.isFuzzy()) {
            for (int i = 0; i < 9; ++i) {
                tile.fuzzyFlags[i].ignore_dmg = this.ignore_dmg[i];
                tile.fuzzyFlags[i].ignore_nbt = this.ignore_nbt[i];
                tile.fuzzyFlags[i].use_od = this.use_od[i];
                tile.fuzzyFlags[i].use_category = this.use_category[i];
            }
        }
        tile.targetType = this.targetType;
        return new GuiLogisticsCraftingTable(player, tile);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        LogisticsCraftingTableTileEntity tile = this.getTile(player.func_130014_f_(), LogisticsCraftingTableTileEntity.class);
        if (tile == null) {
            return null;
        }
        DummyContainer dummy = new DummyContainer(player, tile.matrix, tile);
        for (int X = 0; X < 3; ++X) {
            for (int Y = 0; Y < 3; ++Y) {
                dummy.addFuzzyDummySlot(Y * 3 + X, 35 + X * 18, 10 + Y * 18, tile.fuzzyFlags[Y * 3 + X]);
            }
        }
        dummy.addFuzzyUnmodifiableSlot(0, tile.resultInv, 125, 28, tile.outputFuzzyFlags);
        for (int Y = 0; Y < 2; ++Y) {
            for (int X = 0; X < 9; ++X) {
                dummy.addNormalSlot(Y * 9 + X, tile.inv, 8 + X * 18, 80 + Y * 18);
            }
        }
        dummy.addNormalSlotsForPlayerInventory(8, 135);
        return dummy;
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeItemIdentifier(this.targetType);
        output.writeBoolean(this.isFuzzy);
        if (this.isFuzzy) {
            for (int i = 0; i < 9; ++i) {
                output.writeBoolean(this.ignore_dmg[i]);
                output.writeBoolean(this.ignore_nbt[i]);
                output.writeBoolean(this.use_od[i]);
                output.writeBoolean(this.use_category[i]);
            }
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.targetType = input.readItemIdentifier();
        if (input.readBoolean()) {
            for (int i = 0; i < 9; ++i) {
                this.ignore_dmg[i] = input.readBoolean();
                this.ignore_nbt[i] = input.readBoolean();
                this.use_od[i] = input.readBoolean();
                this.use_category[i] = input.readBoolean();
            }
        }
    }

    public AutoCraftingGui setCraftingTable(LogisticsCraftingTableTileEntity tile) {
        this.setTilePos(tile);
        if (tile.isFuzzy()) {
            this.isFuzzy = true;
            for (int i = 0; i < 9; ++i) {
                this.ignore_dmg[i] = tile.fuzzyFlags[i].ignore_dmg;
                this.ignore_nbt[i] = tile.fuzzyFlags[i].ignore_nbt;
                this.use_od[i] = tile.fuzzyFlags[i].use_od;
                this.use_category[i] = tile.fuzzyFlags[i].use_category;
            }
        }
        this.targetType = tile.targetType;
        return this;
    }

    @Override
    public GuiProvider template() {
        return new AutoCraftingGui(this.getId());
    }
}

