/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import logisticspipes.LogisticsPipes;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyModuleContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class ModuleCoordinatesPacket
extends CoordinatesPacket {
    private LogisticsModule.ModulePositionType type;
    private int positionInt;
    private boolean moduleBased = false;

    public ModuleCoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.type != null);
        if (this.type != null) {
            output.writeEnum(this.type);
            output.writeInt(this.positionInt);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        if (input.readBoolean()) {
            this.type = input.readEnum(LogisticsModule.ModulePositionType.class);
            this.positionInt = input.readInt();
        }
    }

    public ModuleCoordinatesPacket setModulePos(LogisticsModule module) {
        this.type = module.getSlot();
        this.positionInt = module.getPositionInt();
        this.setPosX(module.getX());
        this.setPosY(module.getY());
        this.setPosZ(module.getZ());
        return this;
    }

    public ModuleCoordinatesPacket setPacketPos(ModuleCoordinatesPacket packet) {
        this.type = packet.type;
        this.positionInt = packet.positionInt;
        super.setPacketPos(packet);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> T getLogisticsModule(EntityPlayer player, Class<T> clazz) {
        LogisticsModule module;
        if (this.type == LogisticsModule.ModulePositionType.IN_PIPE) {
            this.moduleBased = true;
            LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
            this.moduleBased = false;
            if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
                this.targetNotFound("Couldn't find " + clazz.getName() + ", pipe didn't exsist");
                return null;
            }
            module = ((CoreRoutedPipe)pipe.pipe).getLogisticsModule();
        } else if (this.type == LogisticsModule.ModulePositionType.IN_HAND) {
            if (MainProxy.isServer((IBlockAccess)player.func_130014_f_())) {
                if (!(player.field_71070_bA instanceof DummyModuleContainer)) {
                    this.targetNotFound("Couldn't find " + clazz.getName() + ", container wasn't a DummyModule Container");
                    return null;
                }
                DummyModuleContainer dummy = (DummyModuleContainer)player.field_71070_bA;
                module = dummy.getModule();
            } else {
                module = MainProxy.proxy.getModuleFromGui();
                if (module == null) {
                    this.targetNotFound("Couldn't find " + clazz.getName() + ", GUI didn't provide the module");
                    return null;
                }
            }
        } else {
            this.moduleBased = true;
            LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
            this.moduleBased = false;
            if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
                this.targetNotFound("Couldn't find " + clazz.getName() + ", pipe didn't exsist");
                return null;
            }
            if (!pipe.isInitialized()) {
                return null;
            }
            if (!(pipe.pipe instanceof PipeLogisticsChassi)) {
                this.targetNotFound("Couldn't find " + clazz.getName() + ", pipe wasn't a chassi pipe");
                return null;
            }
            module = ((PipeLogisticsChassi)pipe.pipe).getLogisticsModule().getSubModule(this.positionInt);
        }
        if (module != null) {
            if (clazz.isAssignableFrom(module.getClass())) return (T)module;
            this.targetNotFound("Couldn't find " + clazz.getName() + ", found " + module.getClass());
            return null;
        } else {
            this.targetNotFound("Couldn't find " + clazz.getName());
        }
        return (T)module;
    }

    @Override
    public <T> T getTile(World world, Class<T> clazz) {
        if (LogisticsPipes.isDEBUG() && !this.moduleBased && this.type != null) {
            new Exception("ModulePacket was asked for a pipe").printStackTrace();
        }
        return super.getTile(world, clazz);
    }

    public LogisticsModule.ModulePositionType getType() {
        return this.type;
    }

    public ModuleCoordinatesPacket setType(LogisticsModule.ModulePositionType type) {
        this.type = type;
        return this;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public ModuleCoordinatesPacket setPositionInt(int positionInt) {
        this.positionInt = positionInt;
        return this;
    }
}

