/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractguis;

import logisticspipes.LogisticsPipes;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class ModuleCoordinatesGuiProvider
extends CoordinatesGuiProvider {
    private LogisticsModule.ModulePositionType slot;
    private int positionInt;

    public ModuleCoordinatesGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeEnum(this.slot);
        output.writeInt(this.positionInt);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.slot = input.readEnum(LogisticsModule.ModulePositionType.class);
        this.positionInt = input.readInt();
    }

    public <T> T getLogisticsModule(World world, Class<T> clazz) {
        LogisticsModule module;
        LogisticsTileGenericPipe pipe = this.getPipe(world);
        if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
            if (LogisticsPipes.isDEBUG() && (pipe == null || pipe.isInitialized())) {
                LogisticsPipes.log.fatal(this.toString());
                new RuntimeException("Couldn't find " + clazz.getName() + ", pipe didn't exsist").printStackTrace();
            }
            return null;
        }
        if (this.slot == LogisticsModule.ModulePositionType.IN_PIPE) {
            module = ((CoreRoutedPipe)pipe.pipe).getLogisticsModule();
        } else {
            if (this.slot == LogisticsModule.ModulePositionType.IN_HAND) {
                throw new UnsupportedOperationException("NO IN_HAND FOR THIS PACKET TYPE");
            }
            if (!(pipe.pipe instanceof PipeLogisticsChassi)) {
                if (LogisticsPipes.isDEBUG()) {
                    LogisticsPipes.log.fatal(this.toString());
                    new RuntimeException("Couldn't find " + clazz.getName() + ", pipe wasn't a chassi pipe").printStackTrace();
                }
                return null;
            }
            module = ((PipeLogisticsChassi)pipe.pipe).getLogisticsModule().getSubModule(this.positionInt);
        }
        if (module != null) {
            if (!clazz.isAssignableFrom(module.getClass())) {
                if (LogisticsPipes.isDEBUG()) {
                    LogisticsPipes.log.fatal(this.toString());
                    new RuntimeException("Couldn't find " + clazz.getName() + ", found " + module.getClass()).printStackTrace();
                }
                return null;
            }
        } else if (LogisticsPipes.isDEBUG()) {
            LogisticsPipes.log.fatal(this.toString());
            new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
        }
        return (T)module;
    }

    public LogisticsModule.ModulePositionType getSlot() {
        return this.slot;
    }

    public ModuleCoordinatesGuiProvider setSlot(LogisticsModule.ModulePositionType slot) {
        this.slot = slot;
        return this;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public ModuleCoordinatesGuiProvider setPositionInt(int positionInt) {
        this.positionInt = positionInt;
        return this;
    }
}

