/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.PlayerConfigToServerPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiCheckBox;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.LogisticsBaseTabGuiScreen;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.config.ClientConfiguration;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiLogisticsSettings
extends LogisticsBaseTabGuiScreen {
    private static final String PREFIX = "gui.settings.";

    public GuiLogisticsSettings(EntityPlayer player) {
        super(180, 220);
        DummyContainer dummy = new DummyContainer(player, null, new IGuiOpenControler[0]);
        dummy.addNormalSlotsForPlayerInventory(10, 135);
        this.addTab(new PipeRenderSettings());
        this.field_147002_h = dummy;
    }

    private class PipeRenderSettings
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        private InputBar renderDistance;
        private InputBar contentRenderDistance;
        private GuiCheckBox useNewRendererButton;
        private GuiCheckBox useFallbackRendererButton;

        private PipeRenderSettings() {
            super(GuiLogisticsSettings.this);
        }

        @Override
        public void initTab() {
            Keyboard.enableRepeatEvents((boolean)true);
            ClientConfiguration config = LogisticsPipes.getClientPlayerConfig();
            if (this.renderDistance == null) {
                this.renderDistance = new InputBar(GuiLogisticsSettings.this.field_146289_q, GuiLogisticsSettings.this.getBaseScreen(), 15, 75, 30, 15, false, true, InputBar.Align.RIGHT);
                this.renderDistance.setInteger(config.getRenderPipeDistance());
            }
            this.renderDistance.reposition(15, 80, 30, 15);
            if (this.contentRenderDistance == null) {
                this.contentRenderDistance = new InputBar(GuiLogisticsSettings.this.field_146289_q, GuiLogisticsSettings.this.getBaseScreen(), 15, 105, 30, 15, false, true, InputBar.Align.RIGHT);
                this.contentRenderDistance.setInteger(config.getRenderPipeContentDistance());
            }
            this.contentRenderDistance.reposition(15, 110, 30, 15);
        }

        @Override
        public void renderIcon(int x, int y) {
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
            ItemStack stack = new ItemStack(LPItems.pipeBasic, 1);
            GuiLogisticsSettings.this.field_146296_j.func_180450_b(stack, x, y);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            ((GuiLogisticsSettings)GuiLogisticsSettings.this).field_146296_j.field_77023_b = 0.0f;
        }

        @Override
        public void renderBackgroundContent() {
        }

        @Override
        public void buttonClicked(GuiButton button) {
            if (button == this.useNewRendererButton) {
                this.useNewRendererButton.change();
            }
            if (button == this.useFallbackRendererButton) {
                this.useFallbackRendererButton.change();
            }
        }

        @Override
        public void renderForgroundContent() {
            this.renderDistance.func_146194_f();
            this.contentRenderDistance.func_146194_f();
            GuiLogisticsSettings.this.field_146289_q.func_78276_b(StringUtils.translate("gui.settings.piperenderdistance"), 10, 70, 0x404040);
            GuiLogisticsSettings.this.field_146289_q.func_78276_b(StringUtils.translate("gui.settings.pipecontentrenderdistance"), 10, 100, 0x404040);
        }

        @Override
        public boolean handleClick(int x, int y, int type) {
            boolean val1 = this.renderDistance.handleClick(x - GuiLogisticsSettings.this.field_147003_i, y - GuiLogisticsSettings.this.field_147009_r, type);
            boolean val2 = this.contentRenderDistance.handleClick(x - GuiLogisticsSettings.this.field_147003_i, y - GuiLogisticsSettings.this.field_147009_r, type);
            return val1 || val2;
        }

        @Override
        public boolean handleKey(int code, char c) {
            return this.renderDistance.handleKey(c, code) || this.contentRenderDistance.handleKey(c, code);
        }

        @Override
        public void guiClose() {
            ClientConfiguration config = LogisticsPipes.getClientPlayerConfig();
            try {
                config.setRenderPipeDistance(this.renderDistance.getInteger());
                config.setRenderPipeContentDistance(this.contentRenderDistance.getInteger());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(PlayerConfigToServerPacket.class).setConfig(config));
        }
    }
}

