/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.farming.logic.crops.Crop;
import ic2.api.crops.ICropTile;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class CropBasicIC2Crop
extends Crop {
    private final TileEntity tileEntity;

    public CropBasicIC2Crop(@Nonnull World world, @Nonnull TileEntity tileEntity, @Nonnull BlockPos position) {
        super(world, position);
        this.tileEntity = tileEntity;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return CropBasicIC2Crop.canHarvestCrop(this.tileEntity);
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        return CropBasicIC2Crop.getCropDrops(this.tileEntity);
    }

    @Optional.Method(modid="ic2")
    public static boolean isIC2Crop(TileEntity tileEntity) {
        return tileEntity instanceof ICropTile;
    }

    @Optional.Method(modid="ic2")
    public static boolean canHarvestCrop(TileEntity tileEntity) {
        if (CropBasicIC2Crop.isIC2Crop(tileEntity)) {
            ICropTile crop = (ICropTile)tileEntity;
            if (crop.getCrop() == null) {
                return false;
            }
            return crop.getCurrentSize() == crop.getCrop().getOptimalHarvestSize(crop);
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    private static NonNullList<ItemStack> getCropDrops(TileEntity tileEntity) {
        if (CropBasicIC2Crop.isIC2Crop(tileEntity)) {
            ICropTile crop = (ICropTile)tileEntity;
            NonNullList drops = NonNullList.func_191196_a();
            drops.addAll((Collection)crop.performHarvest());
            return drops;
        }
        return null;
    }
}

