/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.common.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import xt9.inworldcrafting.common.event.EntityMatcher;
import xt9.inworldcrafting.common.recipe.FluidToFluidRecipe;

@ZenClass(value="mods.inworldcrafting.FluidToFluid")
public class FluidToFluid {
    @ZenMethod
    public static void transform(ILiquidStack outputFluid, ILiquidStack inputFluid, IIngredient[] ingredients) {
        FluidToFluid.transform(outputFluid, inputFluid, ingredients, true);
    }

    @ZenMethod
    public static void transform(ILiquidStack outputFluid, ILiquidStack inputFluid, IIngredient[] ingredients, boolean consume) {
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i].getLiquids().size() <= 0) continue;
            return;
        }
        int inputlength = ingredients.length > 4 ? 4 : ingredients.length;
        IIngredient[] inputs = new IIngredient[inputlength];
        System.arraycopy(ingredients, 0, inputs, 0, inputs.length);
        String outputFluidName = FluidToFluid.getFluidName(outputFluid);
        String inputFluidName = FluidToFluid.getFluidName(inputFluid);
        boolean isValidOutBlock = true;
        Fluid outFluid = FluidRegistry.getFluid((String)outputFluidName);
        if (outFluid.getBlock() == null) {
            isValidOutBlock = false;
            CraftTweakerAPI.logError((String)("inworldcrafting: <liquid:" + outFluid.getName() + "> has no registered Block, it cannot be used as an Output for FluidToFluid crafting."));
        }
        if (isValidOutBlock) {
            EntityMatcher.allValidInputs.add((Object)ingredients[0]);
            FluidToFluidRecipe.addRecipe(outputFluidName, inputFluidName, inputs, consume);
        }
    }

    private static String getFluidName(ILiquidStack stack) {
        return stack.getDefinition().getName();
    }
}

