/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.events.SidebarButtonCreatedEvent;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftbquests.block.BlockDetector;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.client.RenderPlayerDetector;
import com.feed_the_beast.ftbquests.client.RenderProgressScreen;
import com.feed_the_beast.ftbquests.client.RenderTaskScreen;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.events.ThemePropertyEvent;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.task.ObservationTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.ftbquests.tile.TilePlayerDetector;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.util.RayMatcher;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbquests", value={Side.CLIENT})
public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    public static TextureAtlasSprite inputBlockSprite;
    private static List<ObservationTask> observationTasks;
    private static ObservationTask currentlyObserving;
    private static int currentlyObservingTime;

    private static void addModel(Item item, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.SCREEN, "facing=north");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.PROGRESS_DETECTOR, "normal");
        for (BlockDetector.Variant variant : BlockDetector.Variant.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.DETECTOR, (int)variant.ordinal(), (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.DETECTOR.getRegistryName(), "variant=" + variant.func_176610_l()));
        }
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.PROGRESS_SCREEN, "facing=north");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.CHEST, "facing=north");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.LOOT_CRATE_STORAGE, "normal");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.LOOT_CRATE_OPENER, "normal");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.BARRIER, "completed=false");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.BOOK, "inventory");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.LOOTCRATE, "inventory");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.CUSTOM_ICON, "inventory");
        ClientRegistry.bindTileEntitySpecialRenderer(TileTaskScreenCore.class, (TileEntitySpecialRenderer)new RenderTaskScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileProgressScreenCore.class, (TileEntitySpecialRenderer)new RenderProgressScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePlayerDetector.class, (TileEntitySpecialRenderer)new RenderPlayerDetector());
    }

    @SubscribeEvent
    public static void registerProperties(ThemePropertyEvent event) {
        ThemeProperties.register(event);
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((stack, tintIndex) -> {
            LootCrate crate = ItemLootCrate.getCrate(null, stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, new Item[]{FTBQuestsItems.LOOTCRATE});
    }

    @SubscribeEvent
    public static void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (!ClientQuestFile.existsWithTeam()) {
                        return "[!]";
                    }
                    int r = ClientQuestFile.INSTANCE.getUnclaimedRewards(Minecraft.func_71410_x().field_71439_g.func_110124_au(), ClientQuestFile.INSTANCE.self, true);
                    if (r > 0) {
                        return Integer.toString(r);
                    }
                }
                return "";
            });
            event.getButton().setTooltipHandler(list -> {
                if (ClientQuestFile.exists() && !ClientQuestFile.existsWithTeam()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"sidebar_button.ftbquests.quests.no_team", (Object[])new Object[0]));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onFileCacheClear(ClearFileCacheEvent event) {
        observationTasks = null;
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBQuestsClient.KEY_QUESTS.func_151468_f()) {
            ClientQuestFile.INSTANCE.openQuestGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbquests") && "open_gui".equals(event.getID().func_110623_a())) {
            ClientQuestFile.INSTANCE.openQuestGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        inputBlockSprite = event.getMap().func_174942_a(new ResourceLocation("ftbquests", "blocks/screen_front_input"));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null && ClientQuestFile.existsWithTeam()) {
            if (observationTasks == null) {
                observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (observationTasks.isEmpty()) {
                return;
            }
            currentlyObserving = null;
            RayMatcher.Data data = RayMatcher.Data.get((World)mc.field_71441_e, mc.field_71476_x);
            for (ObservationTask task : observationTasks) {
                if (task.isComplete(ClientQuestFile.INSTANCE.self) || !task.matcher.matches(data) || !task.quest.canStartTasks(ClientQuestFile.INSTANCE.self)) continue;
                currentlyObserving = task;
                break;
            }
            if (currentlyObserving != null) {
                if (!mc.func_147113_T()) {
                    ++currentlyObservingTime;
                }
                if ((long)currentlyObservingTime >= FTBQuestsClientEventHandler.currentlyObserving.timer.ticks()) {
                    new MessageSubmitTask(FTBQuestsClientEventHandler.currentlyObserving.id).sendToServer();
                    ClientQuestFile.INSTANCE.self.getTaskData(currentlyObserving).addProgress(1L);
                    currentlyObserving = null;
                    currentlyObservingTime = 0;
                }
            } else {
                currentlyObservingTime = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onScreenRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || !ClientQuestFile.existsWithTeam()) {
            return;
        }
        GlStateManager.func_179147_l();
        Minecraft mc = Minecraft.func_71410_x();
        int cy = event.getResolution().func_78328_b() / 2;
        if (currentlyObserving != null) {
            int cx = event.getResolution().func_78326_a() / 2;
            String cot = TextFormatting.UNDERLINE.toString() + TextFormatting.YELLOW + currentlyObserving.getTitle();
            int sw = mc.field_71466_p.func_78256_a(cot);
            int bw = Math.max(sw, 100);
            Color4I.DARK_GRAY.withAlpha(130).draw(cx - bw / 2 - 3, cy - 63, bw + 6, 29);
            GuiHelper.drawHollowRect((int)(cx - bw / 2 - 3), (int)(cy - 63), (int)(bw + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            mc.field_71466_p.func_175063_a(cot, (float)(cx - sw / 2), (float)(cy - 60), 0xFFFFFF);
            double completed = (double)((float)currentlyObservingTime + event.getPartialTicks()) / (double)FTBQuestsClientEventHandler.currentlyObserving.timer.ticks();
            GuiHelper.drawHollowRect((int)(cx - bw / 2), (int)(cy - 49), (int)bw, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            Color4I.LIGHT_BLUE.withAlpha(130).draw(cx - bw / 2 + 1, cy - 48, (int)(((double)bw - 2.0) * completed), 10);
            String cop = (long)currentlyObservingTime * 100L / FTBQuestsClientEventHandler.currentlyObserving.timer.ticks() + "%";
            mc.field_71466_p.func_175063_a(cop, (float)(cx - mc.field_71466_p.func_78256_a(cop) / 2), (float)(cy - 47), 0xFFFFFF);
        }
        if (!ClientQuestFile.INSTANCE.pinnedQuests.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            boolean first = true;
            if (ClientQuestFile.INSTANCE.pinnedQuests.contains(1)) {
                for (Chapter chapter : ClientQuestFile.INSTANCE.chapters) {
                    for (Quest quest : chapter.quests) {
                        if (quest.isComplete(ClientQuestFile.INSTANCE.self) || !quest.canStartTasks(ClientQuestFile.INSTANCE.self)) continue;
                        if (first) {
                            first = false;
                        } else {
                            list.add("");
                        }
                        list.add(TextFormatting.BOLD + mc.field_71466_p.func_78269_a(quest.getTitle(), 160) + " " + TextFormatting.DARK_AQUA + quest.getRelativeProgress(ClientQuestFile.INSTANCE.self) + "%");
                        for (Task task : quest.tasks) {
                            if (task.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                            list.add(TextFormatting.GRAY + mc.field_71466_p.func_78269_a(task.getTitle(), 160) + " " + TextFormatting.GREEN + ClientQuestFile.INSTANCE.self.getTaskData(task).getProgressString() + "/" + task.getMaxProgressString());
                        }
                    }
                }
            } else {
                IntIterator sw = ClientQuestFile.INSTANCE.pinnedQuests.iterator();
                while (sw.hasNext()) {
                    int q = (Integer)sw.next();
                    Quest quest = ClientQuestFile.INSTANCE.getQuest(q);
                    if (quest == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        list.add("");
                    }
                    if (quest.isComplete(ClientQuestFile.INSTANCE.self)) {
                        list.add(TextFormatting.BOLD.toString() + TextFormatting.GREEN + mc.field_71466_p.func_78269_a(quest.getTitle(), 160) + TextFormatting.DARK_GREEN + " 100%");
                        continue;
                    }
                    list.add(TextFormatting.BOLD + mc.field_71466_p.func_78269_a(quest.getTitle(), 160) + " " + TextFormatting.DARK_AQUA + quest.getRelativeProgress(ClientQuestFile.INSTANCE.self) + "%");
                    for (Task task : quest.tasks) {
                        if (task.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                        list.add(TextFormatting.GRAY + mc.field_71466_p.func_78269_a(task.getTitle(), 160) + " " + TextFormatting.GREEN + ClientQuestFile.INSTANCE.self.getTaskData(task).getProgressString() + "/" + task.getMaxProgressString());
                    }
                }
            }
            if (!list.isEmpty()) {
                void var8_23;
                int mw = 0;
                for (String s : list) {
                    mw = Math.max(mw, mc.field_71466_p.func_78256_a(s));
                }
                double scale = (Double)ThemeProperties.PINNED_QUEST_SIZE.get(ClientQuestFile.INSTANCE);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)event.getResolution().func_78326_a() - (double)mw * scale - 8.0), (double)((double)cy - (double)list.size() * 4.5 * scale), (double)100.0);
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
                Color4I.BLACK.withAlpha(100).draw(0, 0, mw + 8, list.size() * 9 + 8);
                boolean bl = false;
                while (var8_23 < list.size()) {
                    mc.field_71466_p.func_175063_a((String)list.get((int)var8_23), 4.0f, (float)(var8_23 * 9 + 4), -1);
                    ++var8_23;
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    static {
        observationTasks = null;
        currentlyObserving = null;
        currentlyObservingTime = 0;
    }
}

