/*
 * Decompiled with CFR 0.152.
 */
package mariot7.xlfoodmod.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="xlfoodmod")
@Config.LangKey(value="xlfoodmod.config.title")
public class Configurationxlfoodmod {
    @Config.Comment(value={"Right Click Harvesting Settings"})
    public static RightClickHarvesting rightclickharvesting = new RightClickHarvesting();
    @Config.Comment(value={"Rock Salt Generation Settings"})
    public static RockSaltGeneration rocksaltgeneration = new RockSaltGeneration();
    @Config.Comment(value={"Grass Generation Settings"})
    public static GrassGeneration grassgeneration = new GrassGeneration();
    @Config.Comment(value={"Vanilla Flower Generation Settings"})
    public static VanillaFlowerGeneration vanillaflowergeneration = new VanillaFlowerGeneration();

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("xlfoodmod")) {
                ConfigManager.sync((String)"xlfoodmod", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class VanillaFlowerGeneration {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable the generation of Vanilla Flowers"})
        public boolean flowergen = true;
        @Config.RangeInt(min=0, max=255)
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Minimum amount of Vanilla Flowers in a chunk"})
        public int minchunk = 0;
        @Config.RangeInt(min=2, max=256)
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Maximum amount of Vanilla Flowers in a chunk"})
        public int maxchunk = 2;
    }

    public static class GrassGeneration {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable the generation of Grass"})
        public boolean grassgen = true;
        @Config.RangeInt(min=0, max=255)
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Minimum amount of Grass in a chunk"})
        public int minchunk = 1;
        @Config.RangeInt(min=2, max=256)
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Maximum amount of Grass in a chunk"})
        public int maxchunk = 4;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Rice Seeds"})
        public double ricechance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Pepper Seeds"})
        public double pepperchance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Corn Seeds"})
        public double cornchance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Cucumber Seeds"})
        public double cucumberchance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Lettuce Seeds"})
        public double lettucechance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Onion"})
        public double onionchance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Tomato Seeds"})
        public double tomatochance = 0.2;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Chance of dropping Strawberry Seeds"})
        public double strawberrychance = 0.2;
    }

    public static class RockSaltGeneration {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable the generation of Rock Salt"})
        public boolean rockgen = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Minimum size of the ore vein"})
        public int minveinsize = 4;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Maximum size of the ore vein"})
        public int maxveinsize = 6;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Minimum height for the ore"})
        public int miny = 6;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Maximum height for the ore"})
        public int maxy = 64;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Maximum veins per chunk"})
        public int chancestospawn = 6;
    }

    public static class RightClickHarvesting {
        @Config.Comment(value={"Enable right click harvesting"})
        public boolean rightclickharvest = false;
    }
}

