/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.TessellatorAbstractBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Vector4f;

@SideOnly(value=Side.CLIENT)
public class TessellatorVertexBuffer
extends TessellatorAbstractBase {
    private static final Map<BufferBuilder, ThreadLocal<TessellatorVertexBuffer>> instances = new HashMap<BufferBuilder, ThreadLocal<TessellatorVertexBuffer>>();
    private final Tessellator tessellator;
    private final BufferBuilder buffer;

    private TessellatorVertexBuffer(BufferBuilder buffer, Tessellator tessellator) {
        this.buffer = buffer;
        this.tessellator = tessellator;
    }

    public static TessellatorVertexBuffer getInstance() {
        return TessellatorVertexBuffer.getInstance(Tessellator.func_178181_a());
    }

    public static TessellatorVertexBuffer getInstance(Tessellator tessellator) {
        return TessellatorVertexBuffer.getInstance(tessellator.func_178180_c(), tessellator);
    }

    public static TessellatorVertexBuffer getInstance(BufferBuilder buffer) {
        return TessellatorVertexBuffer.getInstance(buffer, null);
    }

    private static TessellatorVertexBuffer getInstance(BufferBuilder buffer, Tessellator tessellator) {
        ThreadLocal<TessellatorVertexBuffer> threadLocal;
        TessellatorVertexBuffer tess;
        if (!instances.containsKey(buffer)) {
            instances.put(buffer, new ThreadLocal());
        }
        if ((tess = (threadLocal = instances.get(buffer)).get()) == null) {
            tess = new TessellatorVertexBuffer(buffer, tessellator);
            threadLocal.set(tess);
        }
        return tess;
    }

    public BufferBuilder getVertexBuffer() {
        return this.buffer;
    }

    @Override
    protected void onStartDrawingQuadsCall() {
        this.buffer.func_181668_a(7, this.getVertexFormat());
    }

    @Override
    public ImmutableList<BakedQuad> getQuads() {
        return ImmutableList.of();
    }

    @Override
    protected void onDrawCall() {
        if (this.tessellator != null) {
            this.tessellator.func_78381_a();
        } else {
            this.buffer.func_178977_d();
        }
    }

    @Override
    public void addQuads(List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            this.buffer.func_178981_a(this.transformQuad(quad).func_178209_a());
        }
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, float u, float v) {
        Vector4f pos = new Vector4f(x, y, z, 1.0f);
        this.transform(pos);
        this.buffer.func_181662_b((double)pos.x, (double)pos.y, (double)pos.z);
        this.buffer.func_187315_a((double)u, (double)v);
        this.buffer.func_181669_b((int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f), (int)(this.a * 255.0f));
        this.buffer.func_181663_c(this.normal.x, this.normal.y, this.normal.z);
        this.buffer.func_181675_d();
    }

    @Override
    protected void applyColorMultiplier(EnumFacing side) {
        float preMultiplier = this.getMultiplier(side);
        this.r *= preMultiplier;
        this.g *= preMultiplier;
        this.b *= preMultiplier;
    }

    private float getMultiplier(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return 0.5f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case EAST: 
            case WEST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }
}

