/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.item;

import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.debug.DebugMode;
import com.infinityraider.infinitylib.utility.debug.DebugModeFeedback;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemDebuggerBase
extends ItemBase {
    private final List<DebugMode> DEBUG_MODES = new ArrayList<DebugMode>();

    public ItemDebuggerBase() {
        this(true);
    }

    public ItemDebuggerBase(boolean isVanilla) {
        super("debugger");
        this.DEBUG_MODES.add(new DebugModeFeedback());
        this.DEBUG_MODES.addAll(this.getDebugModes());
    }

    protected abstract List<DebugMode> getDebugModes();

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                DebugMode mode = this.changeDebugMode(stack);
                player.func_145747_a((ITextComponent)new TextComponentString("Set debug mode to " + mode.debugName()));
            }
        } else {
            this.getDebugMode(stack).debugActionClicked(stack, world, player, hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(hand);
            this.getDebugMode(stack).debugActionBlockClicked(stack, player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!player.func_70093_af()) {
            this.getDebugMode(stack).debugActionEntityClicked(stack, player, target, hand);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        DebugMode mode = this.getDebugMode(stack);
        tooltip.add("Right Click to use the debugger in its current mode");
        tooltip.add("Shift + Right Click to cycle debug modes");
        tooltip.add("Current debug mode: " + (mode == null ? "null" : mode.debugName()));
    }

    private DebugMode getDebugMode(ItemStack stack) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        if (!tag.func_74764_b("IL_Count")) {
            tag.func_74768_a("IL_Count", 0);
        }
        return this.DEBUG_MODES.get(tag.func_74762_e("IL_Count") % this.DEBUG_MODES.size());
    }

    private DebugMode changeDebugMode(ItemStack stack) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        int index = !tag.func_74764_b("IL_Count") ? 1 : (tag.func_74762_e("IL_Count") + 1) % this.DEBUG_MODES.size();
        tag.func_74768_a("IL_Count", index);
        return this.DEBUG_MODES.get(index);
    }
}

