/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.asm;

import com.github.terminatornl.tickcentral.TickCentral;
import com.github.terminatornl.tickcentral.api.ClassDebugger;
import com.github.terminatornl.tickcentral.api.ClassSniffer;
import com.github.terminatornl.tickcentral.asm.Utilities;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BlockTransformer
implements IClassTransformer {
    public static final String BLOCK_CLASS_NON_OBF = "net.minecraft.block.Block";
    public static final String BLOCK_CLASS_OBF = FMLDeobfuscatingRemapper.INSTANCE.unmap("net.minecraft.block.Block".replace(".", "/"));
    public static final String TRUE_UPDATE_TICK_NAME = "TickCentral_TrueUpdateTick";
    public static final String TRUE_RANDOM_TICK_NAME = "TickCentral_TrueRandomTick";
    public static Map.Entry<String, String> RANDOM_TICK_METHOD = null;
    public static Map.Entry<String, String> UPDATE_TICK_METHOD = null;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            ClassNode classNode;
            if (basicClass == null) {
                return null;
            }
            ClassReader reader = new ClassReader(basicClass);
            if (!ClassSniffer.isInstanceOf(reader, BLOCK_CLASS_OBF)) {
                return basicClass;
            }
            String className = reader.getClassName();
            if (TickCentral.CONFIG.DEBUG) {
                TickCentral.LOGGER.info("Block found: " + className + " (" + transformedName + ")");
            }
            boolean dirty = false;
            if (RANDOM_TICK_METHOD == null || UPDATE_TICK_METHOD == null) {
                classNode = ClassSniffer.performOnSource(BLOCK_CLASS_OBF, k -> {
                    ClassNode node = new ClassNode();
                    k.accept((ClassVisitor)node, 0);
                    return node;
                });
                HashMap<String, AbstractMap.SimpleEntry<String, Integer>> targetMethods = new HashMap<String, AbstractMap.SimpleEntry<String, Integer>>();
                LinkedList<String> potentialMethods = new LinkedList<String>();
                String targetDescription = null;
                for (MethodNode method : classNode.methods) {
                    method.name = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(classNode.name, method.name, method.desc);
                    method.desc = FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(method.desc);
                    String[] stringArray = method.desc.split(";");
                    if (stringArray.length <= 3 || !stringArray[3].equals("Ljava/util/Random") || !stringArray[stringArray.length - 1].equals(")V")) continue;
                    TickCentral.LOGGER.info("Potential method found: " + className + " -> " + method.name + method.desc);
                    if (potentialMethods.contains(method.desc)) {
                        targetDescription = method.desc;
                        break;
                    }
                    potentialMethods.add(method.desc);
                }
                if (targetDescription == null) {
                    TickCentral.LOGGER.info("Unable to locate the obfuscated updateTick and randomTick method signature!");
                    TickCentral.LOGGER.info("This probably means some other coremod has changed these methods, causing TickCentral not to work. In order to stop you from wasting your time, the server is stopped.");
                    FMLCommonHandler.instance().exitJava(1, false);
                    throw new RuntimeException();
                }
                int highestInstructionCount = Integer.MIN_VALUE;
                for (MethodNode methodNode : classNode.methods) {
                    if (!methodNode.desc.equals(targetDescription)) continue;
                    targetMethods.put(methodNode.name, new AbstractMap.SimpleEntry<String, Integer>(methodNode.desc, methodNode.instructions.size()));
                    highestInstructionCount = Math.max(highestInstructionCount, methodNode.instructions.size());
                }
                if (targetMethods.size() != 2) {
                    TickCentral.LOGGER.info("Unable to determine which methods are updateTick and randomTick!");
                    TickCentral.LOGGER.info("This probably means some other coremod has changed these methods, causing TickCentral not to work. In order to stop you from wasting your time, the server is stopped.");
                    FMLCommonHandler.instance().exitJava(1, false);
                    throw new RuntimeException();
                }
                for (Map.Entry entry : targetMethods.entrySet()) {
                    if ((Integer)((Map.Entry)entry.getValue()).getValue() == highestInstructionCount) {
                        RANDOM_TICK_METHOD = new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), (String)((Map.Entry)entry.getValue()).getKey());
                        TickCentral.LOGGER.info("Found randomTick update method: " + RANDOM_TICK_METHOD.getKey() + RANDOM_TICK_METHOD.getValue());
                        continue;
                    }
                    UPDATE_TICK_METHOD = new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), (String)((Map.Entry)entry.getValue()).getKey());
                    TickCentral.LOGGER.info("Found updateTick update method: " + UPDATE_TICK_METHOD.getKey() + UPDATE_TICK_METHOD.getValue());
                }
            }
            classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 0);
            MethodNode newRandomTick = null;
            MethodNode newUpdateTick = null;
            for (MethodNode method : classNode.methods) {
                if ((method.access & 0x400) != 0) continue;
                if (UPDATE_TICK_METHOD.getKey().equals(method.name) && UPDATE_TICK_METHOD.getValue().equals(method.desc)) {
                    newUpdateTick = Utilities.CopyMethodAppearance(method);
                    newUpdateTick.instructions = new InsnList();
                    newUpdateTick.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "com/github/terminatornl/tickcentral/api/TickHub", "INTERCEPTOR", "Lcom/github/terminatornl/tickcentral/api/TickInterceptor;"));
                    newUpdateTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newUpdateTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    newUpdateTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    newUpdateTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
                    newUpdateTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
                    newUpdateTick.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "com/github/terminatornl/tickcentral/api/TickInterceptor", "redirectUpdateTick", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", true));
                    newUpdateTick.instructions.add((AbstractInsnNode)new InsnNode(177));
                    method.name = TRUE_UPDATE_TICK_NAME;
                    dirty = true;
                    continue;
                }
                if (!RANDOM_TICK_METHOD.getKey().equals(method.name) || !RANDOM_TICK_METHOD.getValue().equals(method.desc)) continue;
                newRandomTick = Utilities.CopyMethodAppearance(method);
                newRandomTick.instructions = new InsnList();
                newRandomTick.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "com/github/terminatornl/tickcentral/api/TickHub", "INTERCEPTOR", "Lcom/github/terminatornl/tickcentral/api/TickInterceptor;"));
                newRandomTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newRandomTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                newRandomTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                newRandomTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
                newRandomTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
                newRandomTick.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "com/github/terminatornl/tickcentral/api/TickInterceptor", "redirectRandomTick", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", true));
                newRandomTick.instructions.add((AbstractInsnNode)new InsnNode(177));
                method.name = TRUE_RANDOM_TICK_NAME;
                dirty = true;
            }
            if (newUpdateTick != null) {
                classNode.methods.add(newUpdateTick);
            }
            if (newRandomTick != null) {
                classNode.methods.add(newRandomTick);
            }
            for (MethodNode method : classNode.methods) {
                dirty = Utilities.convertTargetInstruction(className, RANDOM_TICK_METHOD.getKey(), RANDOM_TICK_METHOD.getValue(), className, TRUE_RANDOM_TICK_NAME, method.instructions) || dirty;
                dirty = Utilities.convertTargetInstruction(className, UPDATE_TICK_METHOD.getKey(), UPDATE_TICK_METHOD.getValue(), className, TRUE_UPDATE_TICK_NAME, method.instructions) || dirty;
                dirty = Utilities.convertSuperInstructions(RANDOM_TICK_METHOD.getKey(), RANDOM_TICK_METHOD.getValue(), TRUE_RANDOM_TICK_NAME, method.instructions) || dirty;
                dirty = Utilities.convertSuperInstructions(UPDATE_TICK_METHOD.getKey(), UPDATE_TICK_METHOD.getValue(), TRUE_UPDATE_TICK_NAME, method.instructions) || dirty;
            }
            if (dirty) {
                return ClassDebugger.WriteClass(classNode, transformedName);
            }
            return basicClass;
        }
        catch (Throwable e) {
            TickCentral.LOGGER.fatal("An error has occurred", e);
            FMLCommonHandler.instance().exitJava(1, false);
            throw new RuntimeException(e);
        }
    }
}

