/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy.loot;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="floralchemy")
public class LootEventHandler {
    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "end_city_treasure": 
                case "stronghold_library": 
                case "stronghold_crossing": 
                case "stronghold_corridor": {
                    event.getTable().addPool(LootEventHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{LootEventHandler.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "floralchemy_inject_pool");
    }

    private static LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("floralchemy", "inject/" + name), weight, 0, new LootCondition[0], "floralchemy_inject_entry");
    }
}

