/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy.block;

import com.minerarcana.floralchemy.item.ItemBlockTinted;
import com.teamacronymcoders.base.blocks.BlockBase;
import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.util.ItemStackUtils;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHedge
extends BlockBase
implements IHasBlockColor {
    private final boolean isThorny;
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockHedge(String name, boolean isThorns) {
        super(Material.field_151584_j, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.2f);
        this.isThorny = isThorns;
        this.setItemBlock((ItemBlock)new ItemBlockTinted<BlockHedge>(this));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (world instanceof WorldServer) {
            WorldServer serverWorld = (WorldServer)world;
            String location = this.isThorny ? "block/thorny_hedge" : "block/hedge";
            LootTable table = serverWorld.func_184146_ak().func_186521_a(new ResourceLocation("floralchemy", location));
            LootContext ctx = new LootContext.Builder(serverWorld).func_186469_a((float)fortune).func_186471_a();
            drops.addAll((Collection)table.func_186462_a(serverWorld.field_73012_v, ctx));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.isThorny) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 3.0f);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            boolean hasNeighbour = false;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos adjacent = pos.func_177972_a(facing);
                if (worldIn.func_180495_p(adjacent).func_177230_c() != this && worldIn.func_180495_p(adjacent).func_185904_a() != Material.field_151577_b && worldIn.func_180495_p(adjacent).func_185904_a() != Material.field_151578_c) continue;
                hasNeighbour = true;
            }
            if (!hasNeighbour) {
                worldIn.func_175698_g(pos);
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185505_j.func_186664_h((double)0.05f);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canThisConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canThisConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canThisConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canThisConnectTo(worldIn, pos, EnumFacing.WEST)));
    }

    private boolean canThisConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, facing.func_176734_d());
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(worldIn, pos, facing);
        Block block = iblockstate.func_177230_c();
        boolean flag = blockfaceshape == BlockFaceShape.MIDDLE_POLE && (iblockstate.func_185904_a() == this.field_149764_J || block instanceof BlockFenceGate);
        return !BlockHedge.isExcepBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID || flag;
    }

    public static boolean isExcepBlockForAttachWithPiston(Block block) {
        return Block.func_193382_c((Block)block) || block == Blocks.field_180401_cv || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150428_aP;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        return world != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos toGrow;
        if (!worldIn.field_72995_K && ItemStackUtils.doItemsMatch((ItemStack)playerIn.func_184586_b(hand), (Item)Items.field_151100_aR) && playerIn.func_184586_b(hand).func_77952_i() == EnumDyeColor.WHITE.func_176767_b() && worldIn.func_175623_d(toGrow = pos.func_177972_a(facing))) {
            worldIn.func_175656_a(toGrow, state);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_184586_b(hand).func_190918_g(1);
            }
            worldIn.func_175718_b(2005, toGrow, 0);
            return true;
        }
        return false;
    }
}

