/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy;

import com.minerarcana.floralchemy.CommonProxy;
import com.minerarcana.floralchemy.Config;
import com.minerarcana.floralchemy.api.FloralchemyAPI;
import com.minerarcana.floralchemy.block.BlockCrystalthorn;
import com.minerarcana.floralchemy.block.BlockFloodedSoil;
import com.minerarcana.floralchemy.block.BlockHedge;
import com.minerarcana.floralchemy.block.BlockLeakyCauldron;
import com.minerarcana.floralchemy.loot.LootFunctionCrystalthorn;
import com.minerarcana.floralchemy.village.VillageHedgeHouse;
import com.minerarcana.floralchemy.village.VillageHedgedHouseHandler;
import com.teamacronymcoders.base.BaseModFoundation;
import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

@Mod(modid="floralchemy", name="Floralchemy", version="1.12.2-1.1.1", dependencies="required-after:base@[3.13.0,);after:thaumcraft; after:botania", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class Floralchemy
extends BaseModFoundation<Floralchemy> {
    public static final String MOD_ID = "floralchemy";
    public static final String MOD_NAME = "Floralchemy";
    public static final String VERSION = "1.12.2-1.1.1";
    public static final String DEPENDS = "required-after:base@[3.13.0,);after:thaumcraft; after:botania";
    @Mod.Instance(value="floralchemy")
    public static Floralchemy instance;
    @SidedProxy(clientSide="com.minerarcana.floralchemy.ClientProxy", serverSide="com.minerarcana.floralchemy.CommonProxy")
    public static CommonProxy proxy;

    public Floralchemy() {
        super(MOD_ID, MOD_NAME, VERSION, CreativeTabs.field_78026_f);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.initConfig(new File(event.getModConfigurationDirectory(), "acronym/floralchemy.cfg"));
        super.preInit(event);
        proxy.registerModels();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new LootFunctionCrystalthorn.Serializer());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MOD_ID, "inject/end_city_treasure"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MOD_ID, "block/hedge"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MOD_ID, "block/thorny_hedge"));
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHedgedHouseHandler());
        MapGenStructureIO.func_143031_a(VillageHedgeHouse.class, (String)"hedge_house");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    public void registerBlocks(BlockRegistry registry) {
        for (Tuple<ResourceLocation, Integer> entry : FloralchemyAPI.getCrystalRegistry().getCrystals()) {
            BlockCrystalthorn block = new BlockCrystalthorn(entry);
            registry.register(new ResourceLocation(MOD_ID, "crystalthorn_" + ((ResourceLocation)entry.func_76341_a()).func_110623_a()), (Object)block);
        }
        registry.register((Block)new BlockHedge("hedge", false));
        registry.register((Block)new BlockHedge("thorny_hedge", true));
        registry.register((Block)new BlockFloodedSoil());
        registry.register((Block)new BlockLeakyCauldron());
    }

    public Floralchemy getInstance() {
        return this;
    }

    public boolean hasConfig() {
        return false;
    }
}

