/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy;

import com.google.common.collect.Maps;
import com.minerarcana.floralchemy.api.FloralchemyAPI;
import com.teamacronymcoders.base.util.files.BaseFileUtils;
import java.io.File;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    private static final Map<String, Tuple<Integer, Integer>> FUEL_DEFAULTS = Maps.newHashMap();
    private static final Map<String, Integer> CRYSTAL_DEFAULTS = Maps.newHashMap();

    public static void initConfig(File configFile) {
        BaseFileUtils.createFile((File)configFile);
        Configuration configuration = new Configuration(configFile);
        Property generateDefaults = configuration.get("general", "generateDefaults", true, "Regenerate Default Fuel Values");
        if (generateDefaults.getBoolean()) {
            String category;
            for (Map.Entry<String, Tuple<Integer, Integer>> entry : FUEL_DEFAULTS.entrySet()) {
                category = "fuelValues." + entry.getKey();
                configuration.getInt("burnTime", category, ((Integer)entry.getValue().func_76341_a()).intValue(), 1, 10000, "Number of ticks this fluid will burn for");
                configuration.getInt("powerPreTick", category, ((Integer)entry.getValue().func_76340_b()).intValue(), 1, 10000, "Amount of Mana produced each Tick");
            }
            for (Map.Entry<String, Object> entry : CRYSTAL_DEFAULTS.entrySet()) {
                category = "crystals." + entry.getKey();
                configuration.getInt("metadata", category, ((Integer)entry.getValue()).intValue(), 0, Short.MAX_VALUE, "Metadata of the crystal item");
            }
            generateDefaults.set(false);
        }
        ConfigCategory fuelValues = configuration.getCategory("fuelValues");
        for (ConfigCategory fuelEntry : fuelValues.getChildren()) {
            String fluidName = fuelEntry.getName();
            int burnTime = fuelEntry.get("burnTime").getInt(1);
            int powerPreTick = fuelEntry.get("powerPreTick").getInt(1);
            FloralchemyAPI.getFluidFuelRegistry().putFuel(fluidName, burnTime, powerPreTick);
        }
        ConfigCategory configCategory = configuration.getCategory("crystals");
        for (ConfigCategory crystalEntry : configCategory.getChildren()) {
            FloralchemyAPI.getCrystalRegistry().putCrystal(new ResourceLocation(crystalEntry.getName()), crystalEntry.get("metadata").getInt(0));
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    static {
        FUEL_DEFAULTS.put("oil", (Tuple<Integer, Integer>)new Tuple((Object)100, (Object)50));
        FUEL_DEFAULTS.put("fuel", (Tuple<Integer, Integer>)new Tuple((Object)750, (Object)50));
        FUEL_DEFAULTS.put("diesel", (Tuple<Integer, Integer>)new Tuple((Object)350, (Object)50));
        FUEL_DEFAULTS.put("biodiesel", (Tuple<Integer, Integer>)new Tuple((Object)250, (Object)50));
        CRYSTAL_DEFAULTS.put("minecraft:diamond", 0);
        CRYSTAL_DEFAULTS.put("minecraft:emerald", 0);
        CRYSTAL_DEFAULTS.put("minecraft:quartz", 0);
        CRYSTAL_DEFAULTS.put("minecraft:prismarine_crystals", 0);
    }
}

