/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreIngredient;

public class MultiOredictIngredient
extends CompoundIngredient {
    MultiOredictIngredient(String ... ores) {
        super(MultiOredictIngredient.getOreIngredients(ores));
    }

    private static Collection<Ingredient> getOreIngredients(String ... ores) {
        if (ores == null || ores.length < 2) {
            throw new IllegalArgumentException("ores must contain at least 2 values");
        }
        ArrayList<Ingredient> children = new ArrayList<Ingredient>(ores.length);
        for (String ore : ores) {
            children.add((Ingredient)new OreIngredient(ore));
        }
        return children;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            JsonArray oreJsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)"ores");
            if (oreJsonArray.size() < 2) {
                throw new JsonSyntaxException("ores must contain at least 2 values");
            }
            ArrayList ores = new ArrayList(oreJsonArray.size());
            oreJsonArray.forEach(el -> ores.add(el.getAsString()));
            return new MultiOredictIngredient(ores.toArray(new String[0]));
        }
    }
}

