/*
 * Decompiled with CFR 0.152.
 */
package sora.bhc.handler;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sora.bhc.BaubleyHeartCanisters;
import sora.bhc.handler.ConfigHandler;
import sora.bhc.handler.JsonHandler;
import sora.bhc.init.ModItems;
import sora.bhc.proxy.CommonProxy;

@Mod.EventBusSubscriber(modid="bhc")
public class DropHandler {
    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer) {
            return;
        }
        if (!CommonProxy.TINKERS_CONSTRUCT_INSTALLED && entity instanceof EntityWitherSkeleton && entity.field_70170_p.field_73012_v.nextDouble() < ConfigHandler.boneDropRate) {
            entity.func_145779_a(ModItems.WITHER_BONE, 1);
        }
        for (ItemStack stack : DropHandler.getEntityDrops(entity)) {
            entity.func_145779_a(stack.func_77973_b(), 1);
        }
    }

    public static List<ItemStack> getEntityDrops(EntityLivingBase entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry entry : BaubleyHeartCanisters.jsonHandler.getObject().entrySet()) {
            ItemStack stack = ItemStack.field_190927_a;
            switch ((String)entry.getKey()) {
                case "red": {
                    stack = new ItemStack(ModItems.RED_HEART);
                    break;
                }
                case "yellow": {
                    stack = new ItemStack(ModItems.YELLOW_HEART);
                    break;
                }
                case "green": {
                    stack = new ItemStack(ModItems.GREEN_HEART);
                    break;
                }
                case "blue": {
                    stack = new ItemStack(ModItems.BLUE_HEART);
                }
            }
            for (Map.Entry catEntry : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                if (JsonHandler.genericValues.contains(catEntry.getKey())) {
                    switch ((String)catEntry.getKey()) {
                        case "hostile": {
                            if (!(entity instanceof IMob) || !entity.func_184222_aU()) break;
                            DropHandler.addWithPercent(list, stack, ((JsonElement)catEntry.getValue()).getAsDouble());
                            break;
                        }
                        case "boss": {
                            if (entity.func_184222_aU() || entity instanceof EntityDragon) break;
                            DropHandler.addWithPercent(list, stack, ((JsonElement)catEntry.getValue()).getAsDouble());
                            break;
                        }
                        case "dragon": {
                            if (!(entity instanceof EntityDragon)) break;
                            DropHandler.addWithPercent(list, stack, ((JsonElement)catEntry.getValue()).getAsDouble());
                        }
                    }
                    continue;
                }
                if (!((String)catEntry.getKey()).equals(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityRegistry.getEntry(entity.getClass())).toString())) continue;
                DropHandler.addWithPercent(list, stack, ((JsonElement)catEntry.getValue()).getAsDouble());
            }
        }
        return list;
    }

    public static void addWithPercent(List<ItemStack> list, ItemStack stack, double percentage) {
        Random random = new Random();
        int percent = (int)(percentage * 100.0);
        if (random.nextInt(100) <= percent) {
            list.add(stack);
        }
    }
}

