/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.bitstream;

import java.io.IOException;
import openmods.utils.io.IByteSink;

public class OutputBitStream {
    private int buffer;
    private int bitCount;
    private final IByteSink sink;
    private int byteCount;
    private final int flushBitCount;

    OutputBitStream(IByteSink sink, int flushBitCount) {
        this.flushBitCount = flushBitCount;
        this.sink = sink;
    }

    public OutputBitStream(IByteSink sink) {
        this(sink, 8);
    }

    private int padBuffer() {
        return this.buffer << this.flushBitCount - this.bitCount;
    }

    public void writeBit(boolean bit) throws IOException {
        if (this.bitCount >= this.flushBitCount) {
            this.flushBuffer(this.padBuffer(), false);
        } else {
            this.buffer <<= 1;
        }
        if (bit) {
            this.buffer |= 1;
        }
        ++this.bitCount;
    }

    public void flush() throws IOException {
        if (this.bitCount > 0) {
            this.flushBuffer(this.padBuffer(), true);
        }
    }

    protected void acceptByte(int b) throws IOException {
        this.sink.acceptByte(b);
        ++this.byteCount;
    }

    protected void flushBuffer(int value, boolean isLastBit) throws IOException {
        this.flushBuffer(value);
    }

    protected final void flushBuffer(int value) throws IOException {
        this.acceptByte(value);
        this.bitCount = 0;
        this.buffer = 0;
    }

    public int bytesWritten() {
        return this.byteCount;
    }
}

