/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.harvest;

public class HarvestLevelName {
    private final String name;
    private final int level;
    private String format = null;

    public static HarvestLevelName readFromConfig(String config) {
        String[] tokens = config.split(":");
        if (tokens.length == 2) {
            int level = Integer.parseInt(tokens[0]);
            return new HarvestLevelName(level, tokens[1]);
        }
        if (tokens.length == 3) {
            int level = Integer.parseInt(tokens[0]);
            return new HarvestLevelName(level, tokens[1], tokens[2]);
        }
        return null;
    }

    public HarvestLevelName(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public HarvestLevelName(int level, String name, String format) {
        this.level = level;
        this.name = name;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getFormatString() {
        return this.format;
    }

    public String getFormatted() {
        if (this.format != null) {
            return String.format(this.format, this.name);
        }
        return this.name;
    }
}

