/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.harvest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import tyra314.toolprogression.api.OverwrittenContent;
import tyra314.toolprogression.config.ConfigHandler;
import tyra314.toolprogression.harvest.BlockOverwrite;

public class BlockHelper {
    private static final String REGEX = "^(?<force>\\!)?(?<effective>\\?)?(?<toolclass>[^\\?=]+)=(?<level>-?\\d+)(@(?<hardness>.+))?$";
    private static final Pattern pattern = Pattern.compile("^(?<force>\\!)?(?<effective>\\?)?(?<toolclass>[^\\?=]+)=(?<level>-?\\d+)(@(?<hardness>.+))?$");
    private static ItemStack[] tools = null;

    private static boolean isToolEffective(ItemStack item, IBlockState state) {
        ItemTool tool = (ItemTool)item.func_77973_b();
        return item.func_150997_a(state) >= tool.field_77862_b.func_77998_b();
    }

    static String getConfigString(IBlockState state) {
        Block block = state.func_177230_c();
        String toolClass = block.getHarvestTool(state);
        if (toolClass == null && !state.func_185904_a().func_76229_l() && state.func_177230_c() != Blocks.field_150357_h && state.func_177230_c() != Blocks.field_150378_br) {
            for (int i = 0; i < tools.length; ++i) {
                if (!BlockHelper.isToolEffective(tools[i], state)) continue;
                String toolclass = (String)tools[i].func_77973_b().getToolClasses(tools[i]).iterator().next();
                state.func_177230_c().setHarvestLevel(toolclass, 0, state);
                return String.format("%s=%d", toolclass, 0);
            }
        }
        if (toolClass == null) {
            return "null=-1";
        }
        int level = block.getHarvestLevel(state);
        return (state.func_185904_a().func_76229_l() ? "?" : "") + String.format("%s=%d", toolClass, level);
    }

    public static String getKeyString(@Nonnull IBlockState state) {
        Block block = state.func_177230_c();
        String key = block.getRegistryName().toString();
        int meta = block.func_176201_c(state);
        return String.format("%s:%d", key, meta);
    }

    public static void applyToAll(Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            BlockHelper.applyTo(state);
        }
    }

    static void applyTo(IBlockState state) {
        String key = BlockHelper.getKeyString(state);
        BlockOverwrite overwrite = ConfigHandler.blockOverwrites.get(key);
        if (overwrite != null) {
            overwrite.apply(state);
        }
        OverwrittenContent.blocks.put(state.func_177230_c().func_149739_a(), overwrite);
    }

    public static BlockOverwrite createFromConfigString(String config, BlockOverwrite.OverwriteSource source, String key) {
        String hardness;
        Matcher matcher = pattern.matcher(config);
        if (!matcher.find()) {
            return null;
        }
        String toolClass = matcher.group("toolclass");
        int level = Integer.parseInt(matcher.group("level"));
        boolean toolRequired = matcher.group("effective") == null;
        BlockOverwrite b = new BlockOverwrite(toolClass, level, toolRequired, source, key);
        if (matcher.group("force") != null) {
            b.destroyable = true;
            if (!b.toolRequired) {
                return null;
            }
        }
        if ((hardness = matcher.group("hardness")) != null) {
            b.hardness = Float.parseFloat(hardness);
        }
        return b;
    }

    public static String getKeyFromItemStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemBlock iblock = (ItemBlock)item;
        Block block = iblock.func_179223_d();
        IBlockState state = block.func_176203_a(item.getDamage(stack));
        return BlockHelper.getKeyString(state);
    }

    static {
        tools = new ItemStack[]{new ItemStack(Items.field_151039_o), new ItemStack(Items.field_151038_n), new ItemStack(Items.field_151053_p)};
    }
}

