/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.compat.waila;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tyra314.toolprogression.api.OverwrittenContent;
import tyra314.toolprogression.compat.gamestages.GSEventHandler;
import tyra314.toolprogression.compat.gamestages.GSHelper;
import tyra314.toolprogression.config.ConfigHandler;
import tyra314.toolprogression.harvest.HarvestHelper;

public class WailaTooltipProvider
implements IWailaDataProvider {
    public static void register(IWailaRegistrar registrar) {
        if (ConfigHandler.waila_enabled) {
            registrar.registerTailProvider((IWailaDataProvider)new WailaTooltipProvider(), Block.class);
        }
    }

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IBlockState state = accessor.getBlockState();
        if (GSHelper.isLoaded()) {
            state = GSEventHandler.getStagedBlockState(accessor.getPlayer(), state);
        }
        String required_toolclass = state.func_177230_c().getHarvestTool(state);
        ItemStack active_tool = accessor.getPlayer().func_184614_ca();
        HarvestHelper.Result r = HarvestHelper.canPlayerHarvestReason(accessor.getPlayer(), state);
        if (accessor.getBlock() != Blocks.field_150357_h && r == HarvestHelper.Result.NONE) {
            if (required_toolclass != null && !active_tool.func_77973_b().getToolClasses(active_tool).contains(required_toolclass) && !required_toolclass.equals("null")) {
                currenttip.add(0, String.format("Effective Tool : \u00a74%s", required_toolclass));
            }
            if (ConfigHandler.waila_show_harvestable) {
                currenttip.add(0, "Harvestable : \u00a72yes");
            }
        } else {
            if (required_toolclass != null && r == HarvestHelper.Result.TOOL_CLASS) {
                currenttip.add(0, String.format("Required Tool : \u00a74%s", required_toolclass));
            } else if (required_toolclass != null && r == HarvestHelper.Result.LEVEL) {
                int required_level = state.func_177230_c().getHarvestLevel(state);
                String harvest_level = String.valueOf(required_level);
                if (OverwrittenContent.mining_level.containsKey(required_level)) {
                    harvest_level = OverwrittenContent.mining_level.get(required_level).getFormatted();
                }
                currenttip.add(0, String.format("Harvest Level : %s", harvest_level));
            }
            currenttip.add(0, "Harvestable : \u00a74no");
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }
}

