/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.compat.tconstruct;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.modifiers.ModDiamond;
import slimeknights.tconstruct.tools.modifiers.ModEmerald;
import tyra314.toolprogression.ToolProgressionMod;
import tyra314.toolprogression.compat.tconstruct.TiCMaterial;
import tyra314.toolprogression.config.ConfigHandler;
import tyra314.toolprogression.proxy.CommonProxy;

public class TiCEventHandler {
    @SubscribeEvent
    public void handleMaterial(MaterialEvent.StatRegisterEvent<HeadMaterialStats> event) {
        String name = event.material.identifier;
        if (event.stats instanceof HeadMaterialStats) {
            HeadMaterialStats stats = (HeadMaterialStats)event.stats;
            if (ConfigHandler.generate_dev_output) {
                CommonProxy.mats_config.getString(name, "material", String.valueOf(stats.harvestLevel), name);
            }
            ToolProgressionMod.logger.info("TiC Material registered: " + name);
            if (TiCMaterial.hasOverwrite(event.material.identifier)) {
                int newLevel = TiCMaterial.getOverwrite(event.material.identifier);
                event.overrideResult((IMaterialStats)new HeadMaterialStats(stats.durability, stats.miningspeed, stats.attack, newLevel));
                ToolProgressionMod.logger.info("TiC Material overwrite: " + String.valueOf(newLevel));
            }
        }
    }

    private int getToolHarvestLevel(ItemStack tinker_tool) {
        return TagUtil.getToolStats((NBTTagCompound)tinker_tool.func_77978_p()).harvestLevel;
    }

    private void setToolHarvestLevel(ItemStack tinker_tool, int harvestLevel) {
        NBTTagCompound tag = tinker_tool.func_77978_p();
        ToolNBT toolData = TagUtil.getToolStats((NBTTagCompound)tag);
        toolData.harvestLevel = harvestLevel;
        TagUtil.setToolTag((NBTTagCompound)tag, (NBTTagCompound)toolData.get());
        tinker_tool.func_77982_d(tag);
    }

    @SubscribeEvent
    public void handleToolModifier(TinkerCraftingEvent.ToolModifyEvent event) {
        if (!ConfigHandler.tconstruct_overwrite_diamond) {
            return;
        }
        ItemStack tool = event.getToolBeforeModification();
        int harvestLevelMod = 0;
        for (IModifier mod : TinkerUtil.getModifiers((ItemStack)event.getItemStack())) {
            int harvestLevelbefore = this.getToolHarvestLevel(tool);
            mod.apply(tool);
            int harvestLevelAfter = this.getToolHarvestLevel(tool);
            if (!(mod instanceof ModDiamond) && !(mod instanceof ModEmerald) || harvestLevelAfter == harvestLevelbefore) continue;
            --harvestLevelMod;
        }
        int harvestLevel = this.getToolHarvestLevel(event.getItemStack());
        this.setToolHarvestLevel(event.getItemStack(), harvestLevel + harvestLevelMod);
    }
}

