/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipeManager;
import com.blakebr0.extendedcrafting.item.ItemMaterial;
import com.blakebr0.extendedcrafting.item.ItemSingularityUltimate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class ItemSingularity
extends ItemMeta
implements IEnableable {
    public static Map<Integer, Integer> singularityColors = new HashMap<Integer, Integer>();
    public static Map<Integer, Object> singularityMaterials = new HashMap<Integer, Object>();
    private Configuration config = ModConfig.config;

    public ItemSingularity() {
        super("ec.singularity", ExtendedCrafting.REGISTRY);
        this.func_77637_a(ExtendedCrafting.CREATIVE_TAB);
    }

    public String func_77653_i(ItemStack stack) {
        String name = this.items.containsKey(stack.func_77960_j()) ? ((ItemMeta.MetaItem)this.items.get(stack.func_77960_j())).getName().replace("_", " ") : "Dummy";
        return WordUtils.capitalize((String)name) + " " + Utils.localize((String)"item.ec.singularity.name");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void init() {
        this.addSingularity(0, "coal", new ItemStack(Items.field_151044_h), 0x1B1B1B);
        this.addSingularity(1, "iron", "ingotIron", 0x969696);
        this.addSingularity(2, "lapis_lazuli", new ItemStack(Items.field_151100_aR, 1, 4), 3432131);
        this.addSingularity(3, "redstone", new ItemStack(Items.field_151137_ax), 0x720000);
        this.addSingularity(4, "glowstone", new ItemStack(Items.field_151114_aO), 0x868600);
        this.addSingularity(5, "gold", "ingotGold", 0xDEDE00);
        this.addSingularity(6, "diamond", "gemDiamond", 2936241);
        this.addSingularity(7, "emerald", "gemEmerald", 43061);
        this.addSingularity(16, "aluminum", "ingotAluminum", 0xCACCDA);
        this.addSingularity(17, "copper", "ingotCopper", 13529601);
        this.addSingularity(18, "tin", "ingotTin", 7770277);
        this.addSingularity(19, "bronze", "ingotBronze", 11040068);
        this.addSingularity(20, "zinc", "ingotZinc", 13619916);
        this.addSingularity(21, "brass", "ingotBrass", 12356386);
        this.addSingularity(22, "silver", "ingotSilver", 8628914);
        this.addSingularity(23, "lead", "ingotLead", 4738919);
        this.addSingularity(24, "steel", "ingotSteel", 0x565656);
        this.addSingularity(25, "nickel", "ingotNickel", 12498050);
        this.addSingularity(26, "constantan", "ingotConstantan", 11109700);
        this.addSingularity(27, "electrum", "ingotElectrum", 10981685);
        this.addSingularity(28, "invar", "ingotInvar", 9608599);
        this.addSingularity(29, "mithril", "ingotMithril", 6658747);
        this.addSingularity(30, "tungsten", "ingotTungsten", 4804177);
        this.addSingularity(31, "titanium", "ingotTitanium", 10921912);
        this.addSingularity(32, "uranium", "ingotUranium", 4620301);
        this.addSingularity(33, "chrome", "ingotChrome", 12691886);
        this.addSingularity(34, "platinum", "ingotPlatinum", 7334639);
        this.addSingularity(35, "iridium", "ingotIridium", 9740222);
        this.addSingularity(48, "signalum", "ingotSignalum", 14498560);
        this.addSingularity(49, "lumium", "ingotLumium", 14607772);
        this.addSingularity(50, "enderium", "ingotEnderium", 740686);
        this.addSingularity(64, "ardite", "ingotArdite", 14305303);
        this.addSingularity(65, "cobalt", "ingotCobalt", 146587);
        this.addSingularity(66, "manyullyn", "ingotManyullyn", 6039178);
        this.config.get("singularity", "default_singularities", new String[0]).setComment("Disable specific default singularities here.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void initModels() {
        for (Map.Entry item : this.items.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)item.getKey()), (ModelResourceLocation)ResourceHelper.getModelResource((String)"extendedcrafting", (String)"singularity", (String)"inventory"));
        }
    }

    public boolean isEnabled() {
        return ModConfig.confSingularityEnabled;
    }

    public ItemStack addSingularity(int meta, String name, ItemStack material, int color) {
        this.addToConfig(name);
        boolean enabled = this.checkConfig(name);
        if (enabled) {
            singularityColors.put(meta, color);
            singularityMaterials.put(meta, material);
            ItemSingularityUltimate.addSingularityToRecipe(new ItemStack((Item)this, 1, meta));
        }
        return this.addItem(meta, name, enabled);
    }

    public ItemStack addSingularity(int meta, String name, String oreName, int color) {
        this.addToConfig(name);
        boolean enabled = this.checkConfig(name);
        if (enabled) {
            singularityColors.put(meta, color);
            singularityMaterials.put(meta, oreName);
            ItemSingularityUltimate.addSingularityToRecipe(new ItemStack((Item)this, 1, meta));
        }
        return this.addItem(meta, name, enabled);
    }

    public void initRecipes() {
        if (!ModConfig.confSingularityRecipes || !this.isEnabled()) {
            return;
        }
        for (Map.Entry<Integer, Object> obj : singularityMaterials.entrySet()) {
            Object value = obj.getValue();
            int meta = obj.getKey();
            if (value instanceof ItemStack) {
                ItemStack stack = (ItemStack)value;
                if (stack.func_190926_b()) continue;
                CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), stack.func_77946_l(), ModConfig.confSingularityAmount, ItemSingularity.getCatalystStack(), false, ModConfig.confSingularityRF);
                continue;
            }
            if (value instanceof String) {
                String name = (String)value;
                CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), name, ModConfig.confSingularityAmount, ItemSingularity.getCatalystStack(), false, ModConfig.confSingularityRF);
                continue;
            }
            ExtendedCrafting.LOGGER.error("Invalid material for singularity: " + value.toString());
        }
    }

    public static ItemStack getCatalystStack() {
        String[] parts = ModConfig.confSingularityCatalyst.split(":");
        if (parts.length != 3) {
            return ItemMaterial.itemUltimateCatalyst;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceHelper.getResource((String)parts[0], (String)parts[1]));
        if (item == null) {
            return ItemMaterial.itemUltimateCatalyst;
        }
        return new ItemStack(item, 1, Integer.parseInt(parts[2]));
    }

    public boolean checkConfig(String name) {
        String[] values = this.config.get("singularity", "default_singularities", new String[0]).getStringList();
        for (int i = 0; i < values.length; ++i) {
            String[] entry = values[i].split("=");
            if (!entry[0].equals(name)) continue;
            return Boolean.valueOf(entry[1]);
        }
        return false;
    }

    private void addToConfig(String name) {
        Property prop = this.config.get("singularity", "default_singularities", new String[0]);
        String[] values = prop.getStringList();
        if (!Arrays.stream(values).anyMatch(s -> s.split("=")[0].equals(name))) {
            String[] newValues = new String[values.length + 1];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = i < values.length ? values[i] : name + "=" + ModConfig.removeSingularity(name);
            }
            prop.set(newValues);
        }
    }

    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            return singularityColors.get(stack.func_77960_j());
        }
    }
}

