/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import extracells.util.StorageChannels;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class TileBase
extends TileEntity {
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void updateBlock() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
    }

    public IStorageGrid getStorageGrid(AEPartLocation side) {
        if (!(this instanceof IGridHost)) {
            return null;
        }
        IGridHost host = (IGridHost)this;
        if (host.getGridNode(side) == null) {
            return null;
        }
        IGrid grid = host.getGridNode(side).getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    @Nullable
    public IMEMonitor<IAEFluidStack> getFluidInventory(AEPartLocation side) {
        IStorageGrid storageGrid = this.getStorageGrid(side);
        if (storageGrid == null) {
            return null;
        }
        return storageGrid.getInventory((IStorageChannel)StorageChannels.FLUID());
    }

    @Nullable
    public IMEMonitor<IAEItemStack> getItemInventory(AEPartLocation side) {
        IStorageGrid storageGrid = this.getStorageGrid(side);
        if (storageGrid == null) {
            return null;
        }
        return storageGrid.getInventory((IStorageChannel)StorageChannels.ITEM());
    }

    @Nullable
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(AEPartLocation side, IStorageChannel<T> channel) {
        IStorageGrid storageGrid = this.getStorageGrid(side);
        if (storageGrid == null) {
            return null;
        }
        return storageGrid.getInventory(channel);
    }

    protected void saveData() {
        this.func_70296_d();
    }
}

