/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.common.util.BlockCompatHelper;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonSerializer;
import hellfirepvp.modularmachinery.common.util.nbt.NBTMatchingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockArray {
    private static final ResourceLocation ic2TileBlock = new ResourceLocation("ic2", "te");
    protected Map<BlockPos, BlockInformation> pattern = new HashMap<BlockPos, BlockInformation>();
    private Vec3i min = new Vec3i(0, 0, 0);
    private Vec3i max = new Vec3i(0, 0, 0);
    private Vec3i size = new Vec3i(0, 0, 0);

    public BlockArray() {
    }

    public BlockArray(BlockArray other) {
        this.pattern = new HashMap<BlockPos, BlockInformation>(other.pattern);
        this.min = new Vec3i(other.min.func_177958_n(), other.min.func_177956_o(), other.min.func_177952_p());
        this.max = new Vec3i(other.max.func_177958_n(), other.max.func_177956_o(), other.max.func_177952_p());
        this.size = new Vec3i(other.size.func_177958_n(), other.size.func_177956_o(), other.size.func_177952_p());
    }

    public BlockArray(BlockArray other, Vec3i offset) {
        for (Map.Entry<BlockPos, BlockInformation> otherEntry : other.pattern.entrySet()) {
            this.pattern.put(otherEntry.getKey().func_177971_a(offset), otherEntry.getValue());
        }
        this.min = new Vec3i(offset.func_177958_n() + other.min.func_177958_n(), offset.func_177956_o() + other.min.func_177956_o(), offset.func_177952_p() + other.min.func_177952_p());
        this.max = new Vec3i(offset.func_177958_n() + other.max.func_177958_n(), offset.func_177956_o() + other.max.func_177956_o(), offset.func_177952_p() + other.max.func_177952_p());
        this.size = new Vec3i(other.size.func_177958_n(), other.size.func_177956_o(), other.size.func_177952_p());
    }

    public void addBlock(int x, int y, int z, @Nonnull BlockInformation info) {
        this.addBlock(new BlockPos(x, y, z), info);
    }

    public void addBlock(BlockPos offset, @Nonnull BlockInformation info) {
        this.pattern.put(offset, info);
        this.updateSize(offset);
    }

    public boolean hasBlockAt(BlockPos pos) {
        return this.pattern.containsKey(pos);
    }

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public Vec3i getMax() {
        return this.max;
    }

    public Vec3i getMin() {
        return this.min;
    }

    public Vec3i getSize() {
        return this.size;
    }

    private void updateSize(BlockPos addedPos) {
        if (addedPos.func_177958_n() < this.min.func_177958_n()) {
            this.min = new Vec3i(addedPos.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177958_n() > this.max.func_177958_n()) {
            this.max = new Vec3i(addedPos.func_177958_n(), this.max.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177956_o() < this.min.func_177956_o()) {
            this.min = new Vec3i(this.min.func_177958_n(), addedPos.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177956_o() > this.max.func_177956_o()) {
            this.max = new Vec3i(this.max.func_177958_n(), addedPos.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177952_p() < this.min.func_177952_p()) {
            this.min = new Vec3i(this.min.func_177958_n(), this.min.func_177956_o(), addedPos.func_177952_p());
        }
        if (addedPos.func_177952_p() > this.max.func_177952_p()) {
            this.max = new Vec3i(this.max.func_177958_n(), this.max.func_177956_o(), addedPos.func_177952_p());
        }
        this.size = new Vec3i(this.max.func_177958_n() - this.min.func_177958_n() + 1, this.max.func_177956_o() - this.min.func_177956_o() + 1, this.max.func_177952_p() - this.min.func_177952_p() + 1);
    }

    public Map<BlockPos, BlockInformation> getPattern() {
        return this.pattern;
    }

    public Map<BlockPos, BlockInformation> getPatternSlice(int slice) {
        HashMap<BlockPos, BlockInformation> copy = new HashMap<BlockPos, BlockInformation>();
        for (BlockPos pos : this.pattern.keySet()) {
            if (pos.func_177956_o() != slice) continue;
            copy.put(pos, this.pattern.get(pos));
        }
        return copy;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAsDescriptiveStacks() {
        return this.getAsDescriptiveStacks(Optional.empty());
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAsDescriptiveStacks(Optional<Long> snapSample) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        for (Map.Entry<BlockPos, BlockInformation> infoEntry : this.pattern.entrySet()) {
            BlockInformation bi = infoEntry.getValue();
            ItemStack s = bi.getDescriptiveStack(snapSample);
            if (s.func_190926_b()) continue;
            boolean found = false;
            for (ItemStack stack : out) {
                if (!stack.func_77973_b().getRegistryName().equals((Object)s.func_77973_b().getRegistryName()) || stack.func_77952_i() != s.func_77952_i()) continue;
                stack.func_190920_e(stack.func_190916_E() + 1);
                found = true;
                break;
            }
            if (found) continue;
            out.add(s);
        }
        return out;
    }

    public boolean matches(World world, BlockPos center, boolean oldState, @Nullable Map<BlockPos, List<BlockInformation>> modifierReplacementPattern) {
        block0: for (Map.Entry<BlockPos, BlockInformation> entry : this.pattern.entrySet()) {
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (entry.getValue().matches(world, at, oldState)) continue;
            if (modifierReplacementPattern != null && modifierReplacementPattern.containsKey(entry.getKey())) {
                for (BlockInformation info : modifierReplacementPattern.get(entry.getKey())) {
                    if (!info.matches(world, at, oldState)) continue;
                    continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public BlockPos getRelativeMismatchPosition(World world, BlockPos center, @Nullable Map<BlockPos, List<BlockInformation>> modifierReplacementPattern) {
        for (Map.Entry<BlockPos, BlockInformation> entry : this.pattern.entrySet()) {
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (entry.getValue().matches(world, at, false)) continue;
            if (modifierReplacementPattern != null && modifierReplacementPattern.containsKey(entry.getKey())) {
                for (BlockInformation info : modifierReplacementPattern.get(entry.getKey())) {
                    if (!info.matches(world, at, false)) continue;
                }
            }
            return entry.getKey();
        }
        return null;
    }

    public BlockArray rotateYCCW() {
        BlockArray out = new BlockArray();
        for (BlockPos pos : this.pattern.keySet()) {
            BlockInformation info = this.pattern.get(pos);
            out.pattern.put(MiscUtils.rotateYCCW(pos), info.copyRotateYCCW());
        }
        return out;
    }

    public String serializeAsMachineJson() {
        String newline = System.getProperty("line.separator");
        String move = "    ";
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(newline);
        sb.append(move).append("\"parts\": [").append(newline);
        Iterator<BlockPos> iterator = this.pattern.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            sb.append(move).append(move).append("{").append(newline);
            sb.append(move).append(move).append(move).append("\"x\": ").append(pos.func_177958_n()).append(",").append(newline);
            sb.append(move).append(move).append(move).append("\"y\": ").append(pos.func_177956_o()).append(",").append(newline);
            sb.append(move).append(move).append(move).append("\"z\": ").append(pos.func_177952_p()).append(",").append(newline);
            BlockInformation bi = this.pattern.get(pos);
            if (bi.matchingTag != null) {
                String strTag = NBTJsonSerializer.serializeNBT((NBTBase)bi.matchingTag);
                sb.append(move).append(move).append(move).append("\"nbt\": ").append(strTag).append(",").append(newline);
            }
            sb.append(move).append(move).append(move).append("\"elements\": [").append(newline);
            Iterator iterator1 = bi.samples.iterator();
            while (iterator1.hasNext()) {
                IBlockState descriptor = (IBlockState)iterator1.next();
                int meta = descriptor.func_177230_c().func_176201_c(descriptor);
                String str = descriptor.func_177230_c().getRegistryName().toString() + "@" + meta;
                sb.append(move).append(move).append(move).append(move).append("\"").append(str).append("\"");
                if (iterator1.hasNext()) {
                    sb.append(",");
                }
                sb.append(newline);
            }
            sb.append(move).append(move).append(move).append("]").append(newline);
            sb.append(move).append(move).append("}");
            if (iterator.hasNext()) {
                sb.append(",");
            }
            sb.append(newline);
        }
        sb.append(move).append("]");
        sb.append("}");
        return sb.toString();
    }

    public static class TileInstantiateContext {
        private final World world;
        private final BlockPos pos;

        public TileInstantiateContext(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        public World getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void apply(TileEntity te) {
            if (te != null) {
                te.func_145834_a(this.world);
                te.func_174878_a(this.pos);
            }
        }
    }

    public static class IBlockStateDescriptor {
        public final List<IBlockState> applicable = Lists.newArrayList();

        private IBlockStateDescriptor() {
        }

        private IBlockStateDescriptor(Block block) {
            ArrayList usedMetas = Lists.newArrayList();
            if (!(block instanceof BlockLiquid) && !(block instanceof BlockFluidBase)) {
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    int meta = block.func_176201_c(state);
                    if (usedMetas.contains(meta)) continue;
                    usedMetas.add(meta);
                    this.applicable.add(state);
                }
            }
            if (this.applicable.isEmpty()) {
                this.applicable.add(block.func_176223_P());
            }
        }

        public IBlockStateDescriptor(IBlockState state) {
            this.applicable.add(state);
        }
    }

    public static class BlockInformation {
        public static final int CYCLE_TICK_SPEED = 30;
        public List<IBlockStateDescriptor> matchingStates;
        private List<IBlockState> samples = Lists.newLinkedList();
        public NBTTagCompound matchingTag = null;

        public BlockInformation(List<IBlockStateDescriptor> matching) {
            this.matchingStates = Lists.newLinkedList(matching);
            for (IBlockStateDescriptor desc : this.matchingStates) {
                this.samples.addAll(desc.applicable);
            }
        }

        public void setMatchingTag(@Nullable NBTTagCompound matchingTag) {
            this.matchingTag = matchingTag;
        }

        public IBlockState getSampleState() {
            return this.getSampleState(Optional.empty());
        }

        public IBlockState getSampleState(Optional<Long> snapTick) {
            int tickSpeed = 30;
            if (this.samples.size() > 10) {
                tickSpeed = (int)((double)tickSpeed * 0.6);
            }
            int p = (int)(snapTick.orElse(ClientScheduler.getClientTick()) / (long)tickSpeed);
            int part = p % this.samples.size();
            return this.samples.get(part);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getDescriptiveStack(Optional<Long> snapTick) {
            IBlockState state = this.getSampleState(snapTick);
            Tuple<IBlockState, TileEntity> recovered = BlockCompatHelper.transformState(state, this.matchingTag, new TileInstantiateContext((World)Minecraft.func_71410_x().field_71441_e, BlockPos.field_177992_a));
            state = (IBlockState)recovered.func_76341_a();
            Block type = state.func_177230_c();
            int meta = type.func_176201_c(state);
            ItemStack s = ItemStack.field_190927_a;
            try {
                s = ic2TileBlock.equals((Object)type.getRegistryName()) ? BlockCompatHelper.tryGetIC2MachineStack(state, recovered.func_76340_b()) : state.func_177230_c().getPickBlock(state, null, null, BlockPos.field_177992_a, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (s.func_190926_b()) {
                if (type instanceof BlockFluidBase) {
                    s = FluidUtil.getFilledBucket((FluidStack)new FluidStack(((BlockFluidBase)type).getFluid(), 1000));
                } else if (type instanceof BlockLiquid) {
                    Material m = state.func_185904_a();
                    s = m == Material.field_151587_i ? new ItemStack(Items.field_151129_at) : (m == Material.field_151586_h ? new ItemStack(Items.field_151131_as) : ItemStack.field_190927_a);
                } else {
                    Item i = Item.func_150898_a((Block)type);
                    if (i != Items.field_190931_a) {
                        s = new ItemStack(i, 1, meta);
                    }
                }
            }
            return s;
        }

        public static IBlockStateDescriptor getDescriptor(String strElement) throws JsonParseException {
            ResourceLocation res;
            Block b;
            int meta = -1;
            int indexMeta = strElement.indexOf(64);
            if (indexMeta != -1 && indexMeta != strElement.length() - 1) {
                try {
                    meta = Integer.parseInt(strElement.substring(indexMeta + 1));
                }
                catch (NumberFormatException exc) {
                    throw new JsonParseException("Expected a metadata number, got " + strElement.substring(indexMeta + 1), (Throwable)exc);
                }
                strElement = strElement.substring(0, indexMeta);
            }
            if ((b = (Block)ForgeRegistries.BLOCKS.getValue(res = new ResourceLocation(strElement))) == null || b == Blocks.field_150350_a) {
                throw new JsonParseException("Couldn't find block with registryName '" + res.toString() + "' !");
            }
            if (meta == -1) {
                return new IBlockStateDescriptor(b);
            }
            return new IBlockStateDescriptor(b.func_176203_a(meta));
        }

        public BlockInformation copyRotateYCCW() {
            ArrayList<IBlockStateDescriptor> newDescriptors = new ArrayList<IBlockStateDescriptor>(this.matchingStates.size());
            for (IBlockStateDescriptor desc : this.matchingStates) {
                IBlockStateDescriptor copy = new IBlockStateDescriptor();
                for (IBlockState applicableState : desc.applicable) {
                    copy.applicable.add(applicableState.func_185907_a(Rotation.COUNTERCLOCKWISE_90));
                }
                newDescriptors.add(copy);
            }
            BlockInformation bi = new BlockInformation(newDescriptors);
            if (this.matchingTag != null) {
                bi.matchingTag = this.matchingTag;
            }
            return bi;
        }

        public BlockInformation copy() {
            ArrayList<IBlockStateDescriptor> descr = new ArrayList<IBlockStateDescriptor>(this.matchingStates.size());
            for (IBlockStateDescriptor desc : this.matchingStates) {
                IBlockStateDescriptor copy = new IBlockStateDescriptor();
                copy.applicable.addAll(desc.applicable);
                descr.add(copy);
            }
            BlockInformation bi = new BlockInformation(descr);
            if (this.matchingTag != null) {
                bi.matchingTag = this.matchingTag;
            }
            return bi;
        }

        public boolean matchesState(IBlockState state) {
            Block atBlock = state.func_177230_c();
            int atMeta = atBlock.func_176201_c(state);
            for (IBlockStateDescriptor descriptor : this.matchingStates) {
                for (IBlockState applicable : descriptor.applicable) {
                    Block type = applicable.func_177230_c();
                    int meta = type.func_176201_c(applicable);
                    if (!type.equals(state.func_177230_c()) || meta != atMeta) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean matches(World world, BlockPos at, boolean default_) {
            TileEntity te;
            if (!world.func_175667_e(at)) {
                return default_;
            }
            if (this.matchingTag != null && (te = world.func_175625_s(at)) != null && this.matchingTag.func_186856_d() > 0) {
                NBTTagCompound cmp = new NBTTagCompound();
                te.func_189515_b(cmp);
                if (!NBTMatchingHelper.matchNBTCompound(this.matchingTag, cmp)) {
                    return false;
                }
            }
            IBlockState state = world.func_180495_p(at);
            Block atBlock = state.func_177230_c();
            int atMeta = atBlock.func_176201_c(state);
            for (IBlockStateDescriptor descriptor : this.matchingStates) {
                for (IBlockState applicable : descriptor.applicable) {
                    Block type = applicable.func_177230_c();
                    int meta = type.func_176201_c(applicable);
                    if (!type.equals(state.func_177230_c()) || meta != atMeta) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

