/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.modifier;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.IntegrationTypeHelper;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class RecipeModifier {
    public static final String IO_INPUT = "input";
    public static final String IO_OUTPUT = "output";
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_MULTIPLY = 1;
    @Nullable
    protected final RequirementType<?, ?> target;
    protected final IOType ioTarget;
    protected final float modifier;
    protected final int operation;
    protected final boolean chance;

    public RecipeModifier(@Nullable RequirementType<?, ?> target, IOType ioTarget, float modifier, int operation, boolean affectsChance) {
        this.target = target;
        this.ioTarget = ioTarget;
        this.modifier = modifier;
        this.operation = operation;
        this.chance = affectsChance;
    }

    @Nullable
    public RequirementType<?, ?> getTarget() {
        return this.target;
    }

    public IOType getIOTarget() {
        return this.ioTarget;
    }

    public float getModifier() {
        return this.modifier;
    }

    public boolean affectsChance() {
        return this.chance;
    }

    public int getOperation() {
        return this.operation;
    }

    public static float applyModifiers(RecipeCraftingContext context, ComponentRequirement<?, ?> in, float value, boolean isChance) {
        Object target = in.getRequirementType();
        return RecipeModifier.applyModifiers(context.getModifiers((RequirementType<?, ?>)((Object)target)), target, in.getActionType(), value, isChance);
    }

    public static float applyModifiers(Collection<RecipeModifier> modifiers, ComponentRequirement<?, ?> in, float value, boolean isChance) {
        return RecipeModifier.applyModifiers(modifiers, in.getRequirementType(), in.getActionType(), value, isChance);
    }

    public static float applyModifiers(Collection<RecipeModifier> modifiers, RequirementType<?, ?> target, IOType ioType, float value, boolean isChance) {
        List applicable = modifiers.stream().filter(mod -> ((Object)mod.getTarget()).equals(target)).filter(mod -> ioType == null || mod.getIOTarget() == ioType).filter(mod -> mod.affectsChance() == isChance).collect(Collectors.toList());
        float add = 0.0f;
        float mul = 1.0f;
        for (RecipeModifier mod2 : applicable) {
            if (mod2.getOperation() == 0) {
                add += mod2.getModifier();
                continue;
            }
            if (mod2.getOperation() == 1) {
                mul *= mod2.getModifier();
                continue;
            }
            throw new RuntimeException("Unknown modifier operation: " + mod2.getOperation());
        }
        return (value + add) * mul;
    }

    public static class Deserializer
    implements JsonDeserializer<RecipeModifier> {
        public RecipeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject part = json.getAsJsonObject();
            if (!(part.has("io") && part.get("io").isJsonPrimitive() && part.getAsJsonPrimitive("io").isString())) {
                throw new JsonParseException("'io' string-tag not found when deserializing recipemodifier!");
            }
            String ioTarget = part.getAsJsonPrimitive("io").getAsString();
            IOType ioType = IOType.getByString(ioTarget);
            if (ioType == null) {
                throw new JsonParseException("Unknown machine iotype: " + ioTarget);
            }
            if (!(part.has("target") && part.get("target").isJsonPrimitive() && part.getAsJsonPrimitive("target").isString())) {
                throw new JsonParseException("'target' string-tag not found when deserializing recipemodifier!");
            }
            String targetStr = part.getAsJsonPrimitive("target").getAsString();
            RequirementType<?, ?> target = (RequirementType<?, ?>)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(new ResourceLocation(targetStr));
            if (target == null && (target = IntegrationTypeHelper.searchRequirementType(targetStr)) != null) {
                ModularMachinery.log.info("[Modular Machinery]: Deprecated requirement name '" + targetStr + "'! Consider using " + target.getRegistryName().toString());
            }
            if (!(part.has("multiplier") && part.get("multiplier").isJsonPrimitive() && part.getAsJsonPrimitive("multiplier").isNumber())) {
                throw new JsonParseException("'multiplier' float-tag not found when deserializing recipemodifier!");
            }
            float multiplier = part.getAsJsonPrimitive("multiplier").getAsFloat();
            if (!(part.has("operation") && part.get("operation").isJsonPrimitive() && part.getAsJsonPrimitive("operation").isNumber())) {
                throw new JsonParseException("'operation' int-tag not found when deserializing recipemodifier!");
            }
            int operation = part.getAsJsonPrimitive("operation").getAsInt();
            if (operation < 0 || operation > 1) {
                throw new JsonParseException("There are currently only operation 0 and 1 available (add and multiply)! Found: " + operation);
            }
            boolean affectsChance = false;
            if (part.has("affectChance")) {
                if (!part.get("affectChance").isJsonPrimitive() || !part.getAsJsonPrimitive("affectChance").isBoolean()) {
                    throw new JsonParseException("'affectChance', if defined, needs to be either true or false!");
                }
                affectsChance = part.getAsJsonPrimitive("affectChance").getAsBoolean();
            }
            return new RecipeModifier(target, ioType, multiplier, operation, affectsChance);
        }
    }
}

