/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.IOInventory;

public abstract class MachineComponent<T> {
    private final IOType ioType;

    public MachineComponent(IOType ioType) {
        this.ioType = ioType;
    }

    public final IOType getIOType() {
        return this.ioType;
    }

    public abstract ComponentType getComponentType();

    public abstract T getContainerProvider();

    public static abstract class EnergyHatch
    extends MachineComponent<IEnergyHandler> {
        public EnergyHatch(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_ENERGY;
        }
    }

    public static abstract class FluidHatch
    extends MachineComponent<HybridTank> {
        public FluidHatch(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_FLUID;
        }
    }

    public static abstract class ItemBus
    extends MachineComponent<IOInventory> {
        public ItemBus(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_ITEM;
        }
    }
}

