/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.tooltip;

import hellfirepvp.modularmachinery.client.util.EnergyDisplayUtil;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TooltipEnergyInput
extends RequirementTip {
    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Collection<ComponentRequirement<?, ?>> filterRequirements(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> requirements) {
        return requirements.stream().filter(r -> r instanceof RequirementEnergy).filter(r -> r.getActionType() == IOType.INPUT).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> buildTooltip(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> filteredComponents) {
        long totalEnergyIn = 0L;
        for (ComponentRequirement<?, ?> energy : filteredComponents) {
            totalEnergyIn += ((RequirementEnergy)energy).getRequiredEnergyPerTick();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        if (totalEnergyIn > 0L) {
            String energyType = I18n.func_135052_a((String)EnergyDisplayUtil.type.getUnlocalizedFormat(), (Object[])new Object[0]);
            long energyIn = EnergyDisplayUtil.type.formatEnergyForDisplay(totalEnergyIn);
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.energy.in", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.energy.in.tick", (Object[])new Object[]{energyIn, energyType}));
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.energy.in.total", (Object[])new Object[]{energyIn * (long)recipe.getRecipeTotalTickTime(), energyType}));
        }
        return tooltip;
    }
}

